/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.CachedRow;
import org.hsqldb.Column;
import org.hsqldb.HsqlException;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class RowOutputTextLog
extends RowOutputBase {
    static final byte[] BYTES_NULL = "NULL".getBytes();
    static final byte[] BYTES_TRUE = "TRUE".getBytes();
    static final byte[] BYTES_FALSE = "FALSE".getBytes();
    static final byte[] BYTES_AND = " AND ".getBytes();
    public static final int MODE_DELETE = 1;
    public static final int MODE_INSERT = 0;
    private boolean isWritten;
    private int logMode;

    public void setMode(int n) {
        this.logMode = n;
    }

    protected void writeFieldPrefix() throws IOException {
        if (this.logMode == 1 && this.isWritten) {
            this.write(BYTES_AND);
        }
    }

    protected void writeChar(String string, int n) throws IOException {
        this.write(39);
        StringConverter.unicodeToAscii(this, string, true);
        this.write(39);
    }

    protected void writeReal(Double d, int n) throws IOException, HsqlException {
        this.writeBytes(Column.createSQLString(d));
    }

    protected void writeSmallint(Number number) throws IOException, HsqlException {
        this.writeBytes(number.toString());
    }

    public void writeEnd() throws IOException {
    }

    protected void writeTime(Time time) throws IOException, HsqlException {
        this.write(39);
        this.writeBytes(time.toString());
        this.write(39);
    }

    protected void writeBinary(Binary binary, int n) throws IOException, HsqlException {
        this.ensureRoom(binary.getBytesLength() * 2 + 2);
        this.write(39);
        StringConverter.writeHex(this.getBuffer(), this.count, binary.getBytes());
        this.count += binary.getBytesLength() * 2;
        this.write(39);
    }

    public void writeType(int n) throws IOException {
    }

    public void writeSize(int n) throws IOException {
    }

    protected void writeDate(Date date) throws IOException, HsqlException {
        this.write(39);
        this.writeBytes(date.toString());
        this.write(39);
    }

    public int getSize(CachedRow cachedRow) {
        return 0;
    }

    protected void writeInteger(Number number) throws IOException, HsqlException {
        this.writeBytes(number.toString());
    }

    protected void writeBigint(Number number) throws IOException, HsqlException {
        this.writeBytes(number.toString());
    }

    protected void writeNull(int n) throws IOException {
        if (this.logMode == 1) {
            this.write(61);
        } else if (this.isWritten) {
            this.write(44);
        }
        this.isWritten = true;
        this.write(BYTES_NULL);
    }

    protected void writeOther(JavaObject javaObject) throws IOException, HsqlException {
        this.ensureRoom(javaObject.getBytesLength() * 2 + 2);
        this.write(39);
        StringConverter.writeHex(this.getBuffer(), this.count, javaObject.getBytes());
        this.count += javaObject.getBytesLength() * 2;
        this.write(39);
    }

    public void writeString(String string) throws IOException {
        StringConverter.unicodeToAscii(this, string, false);
    }

    protected void writeBit(Boolean bl) throws IOException, HsqlException {
        this.write(bl != false ? BYTES_TRUE : BYTES_FALSE);
    }

    protected void writeDecimal(BigDecimal bigDecimal) throws IOException, HsqlException {
        this.writeBytes(bigDecimal.toString());
    }

    protected void writeFieldType(int n) throws IOException {
        if (this.logMode == 1) {
            this.write(61);
        } else if (this.isWritten) {
            this.write(44);
        }
        this.isWritten = true;
    }

    public void writeLongData(long l) {
        this.writeBytes(Long.toString(l));
    }

    public void writeIntData(int n, int n2) throws IOException {
    }

    protected void writeTimestamp(Timestamp timestamp) throws IOException, HsqlException {
        this.write(39);
        this.writeBytes(timestamp.toString());
        this.write(39);
    }

    public void writeIntData(int n) throws IOException {
        this.writeBytes(Integer.toString(n));
    }

    public void reset() {
        super.reset();
        this.isWritten = false;
    }
}

