/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets.in;

import java.nio.ByteBuffer;
import net.sf.jqql.Util;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08BasicInPacket;

public class SystemNotificationPacket
extends _08BasicInPacket {
    private static final byte DELIMIT = 31;
    public int type;
    public int from;
    public int to;
    public String message;
    public String unknownId;
    public byte[] unknownToken;
    public boolean allowAddReverse;

    public SystemNotificationPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    public String getPacketName() {
        return "System Notification _08Packet";
    }

    protected void parseBody(ByteBuffer byteBuffer) throws PacketParseException {
        String string = Util.getString(byteBuffer, 2);
        this.type = Util.getInt(string, 0);
        byteBuffer.get();
        string = Util.getString(byteBuffer, (byte)31);
        this.from = Util.getInt(string, 0);
        string = Util.getString(byteBuffer, (byte)31);
        this.to = Util.getInt(string, 0);
        switch (this.type) {
            case 3: {
                Util.getString(byteBuffer, (byte)31);
                char c = byteBuffer.getChar();
                this.unknownId = Util.getString(byteBuffer, c);
                break;
            }
            case 4: {
                this.message = Util.getString(byteBuffer, (byte)31);
                char c = byteBuffer.getChar();
                this.unknownId = Util.getString(byteBuffer, c);
                break;
            }
            case 40: {
                int n = byteBuffer.get() & 0xFF;
                this.unknownToken = new byte[n];
                byteBuffer.get(this.unknownToken);
                n = byteBuffer.getChar();
                this.unknownId = Util.getString(byteBuffer, n);
                break;
            }
            case 41: {
                int n = byteBuffer.get() & 0xFF;
                this.message = Util.getString(byteBuffer, n);
                this.allowAddReverse = byteBuffer.get() == 1;
                n = byteBuffer.getChar();
                this.unknownId = Util.getString(byteBuffer, n);
                break;
            }
            case 43: {
                int n = byteBuffer.get() & 0xFF;
                this.message = Util.getString(byteBuffer, n);
                byteBuffer.get();
                n = byteBuffer.getChar();
                this.unknownId = Util.getString(byteBuffer, n);
            }
        }
    }
}

