/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.NonFragmentedServiceNamespace;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.operation.BaseMigrationSourceOperation;
import com.hazelcast.internal.partition.operation.LegacyMigrationOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.SimpleExecutionCallback;
import com.hazelcast.spi.impl.servicemanager.ServiceInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;

public final class LegacyMigrationRequestOperation
extends BaseMigrationSourceOperation {
    public LegacyMigrationRequestOperation() {
    }

    public LegacyMigrationRequestOperation(MigrationInfo migrationInfo, int partitionStateVersion) {
        super(migrationInfo, partitionStateVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.verifyMasterOnMigrationSource();
        NodeEngine nodeEngine = this.getNodeEngine();
        Address source = this.migrationInfo.getSource();
        Address destination = this.migrationInfo.getDestination();
        this.verifyExistingTarget(nodeEngine, destination);
        if (destination.equals(source)) {
            this.getLogger().warning("Source and destination addresses are the same! => " + this.toString());
            this.setFailed();
            return;
        }
        InternalPartition partition = this.getPartition();
        this.verifySource(nodeEngine.getThisAddress(), partition);
        this.setActiveMigration();
        if (!this.migrationInfo.startProcessing()) {
            this.getLogger().warning("Migration is cancelled -> " + this.migrationInfo);
            this.setFailed();
            return;
        }
        try {
            this.executeBeforeMigrations();
            Collection<Operation> tasks = this.prepareMigrationOperations();
            InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
            long[] replicaVersions = partitionService.getPartitionReplicaVersionManager().getPartitionReplicaVersions(this.migrationInfo.getPartitionId(), NonFragmentedServiceNamespace.INSTANCE);
            this.invokeMigrationOperation(destination, replicaVersions, tasks);
            this.returnResponse = false;
        }
        catch (Throwable e) {
            this.logThrowable(e);
            this.setFailed();
        }
        finally {
            this.migrationInfo.doneProcessing();
        }
    }

    private void invokeMigrationOperation(Address destination, long[] replicaVersions, Collection<Operation> tasks) throws IOException {
        LegacyMigrationOperation operation = new LegacyMigrationOperation(this.migrationInfo, replicaVersions, tasks, this.partitionStateVersion);
        NodeEngine nodeEngine = this.getNodeEngine();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)operation, destination).setExecutionCallback(new MigrationCallback(this.migrationInfo, this)).setResultDeserialized(true).setCallTimeout(partitionService.getPartitionMigrationTimeout()).setTryCount(12).setTryPauseMillis(10000L).setReplicaIndex(this.getReplicaIndex()).invoke();
    }

    private Collection<Operation> prepareMigrationOperations() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        PartitionReplicationEvent replicationEvent = this.getPartitionReplicationEvent();
        LinkedList<Operation> tasks = new LinkedList<Operation>();
        for (ServiceInfo serviceInfo : nodeEngine.getServiceInfos(MigrationAwareService.class)) {
            MigrationAwareService service = (MigrationAwareService)serviceInfo.getService();
            Operation op = service.prepareReplicationOperation(replicationEvent);
            if (op == null) continue;
            op.setServiceName(serviceInfo.getName());
            tasks.add(op);
        }
        return tasks;
    }

    @Override
    public int getId() {
        return 8;
    }

    private static final class MigrationCallback
    extends SimpleExecutionCallback<Object> {
        final MigrationInfo migrationInfo;
        final LegacyMigrationRequestOperation op;

        private MigrationCallback(MigrationInfo migrationInfo, LegacyMigrationRequestOperation op) {
            this.migrationInfo = migrationInfo;
            this.op = op;
        }

        @Override
        public void notify(Object result) {
            this.op.completeMigration(Boolean.TRUE.equals(result));
        }
    }
}

