/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DiscoveryStrategyConfig {
    private final Map<String, Comparable> properties = new HashMap<String, Comparable>();
    private final String className;
    private final DiscoveryStrategyFactory discoveryStrategyFactory;

    public DiscoveryStrategyConfig(String className) {
        this(className, Collections.emptyMap());
    }

    public DiscoveryStrategyConfig(String className, Map<String, Comparable> properties) {
        this.className = className;
        this.properties.putAll(properties);
        this.discoveryStrategyFactory = null;
    }

    public DiscoveryStrategyConfig(DiscoveryStrategyFactory discoveryStrategyFactory) {
        this(discoveryStrategyFactory, Collections.emptyMap());
    }

    public DiscoveryStrategyConfig(DiscoveryStrategyFactory discoveryStrategyFactory, Map<String, Comparable> properties) {
        this.className = null;
        this.properties.putAll(properties);
        this.discoveryStrategyFactory = discoveryStrategyFactory;
    }

    public String getClassName() {
        return this.className;
    }

    public DiscoveryStrategyFactory getDiscoveryStrategyFactory() {
        return this.discoveryStrategyFactory;
    }

    public void addProperty(String key, Comparable value) {
        this.properties.put(key, value);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public Map<String, Comparable> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String toString() {
        return "DiscoveryStrategyConfig{properties=" + this.properties + ", className='" + this.className + '\'' + ", discoveryStrategyFactory=" + this.discoveryStrategyFactory + '}';
    }
}

