/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.rtcp;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.media.control.JitterBufferControl;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceptionStats;
import net.sf.fmj.media.rtp.BurstMetrics;
import net.sf.fmj.media.rtp.RTCPFeedback;
import net.sf.fmj.media.rtp.RTCPReceiverReport;
import net.sf.fmj.media.rtp.RTCPReport;
import net.sf.fmj.media.rtp.RTCPSenderReport;
import net.sf.fmj.media.rtp.RTPStats;
import net.sf.fmj.media.rtp.RecvSSRCInfo;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.utility.ByteBufferOutputStream;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.MediaStreamStatsImpl;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.device.MediaDeviceSession;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.control.FECDecoderControl;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.service.neomedia.rtp.RTCPExtendedReport;
import org.jitsi.service.neomedia.rtp.RTCPReports;
import org.jitsi.util.Logger;

public class StatisticsEngine
extends SinglePacketTransformer
implements TransformEngine {
    private static final Logger logger = Logger.getLogger(StatisticsEngine.class);
    public static final String RTP_STAT_PREFIX = "rtpstat:";
    private long lost = 0L;
    private long maxInterArrivalJitter = 0L;
    private final MediaStreamImpl mediaStream;
    private final MediaType mediaType;
    private long minInterArrivalJitter = -1L;
    private long numberOfRTCPReports = 0L;

    private static int getLengthIfRTCP(byte[] buf, int off, int len) {
        int words;
        int bytes;
        int v;
        if (off >= 0 && len >= 4 && buf != null && buf.length >= off + len && (v = (buf[off] & 0xC0) >>> 6) == 2 && (bytes = ((words = (buf[off + 2] << 8) + (buf[off + 3] << 0)) + 1) * 4) <= len) {
            return bytes;
        }
        return -1;
    }

    private static boolean isRTCP(RawPacket pkt) {
        return StatisticsEngine.getLengthIfRTCP(pkt.getBuffer(), pkt.getOffset(), pkt.getLength()) > 0;
    }

    private static List<RTCPExtendedReport> removeRTCPExtendedReports(RawPacket pkt) {
        byte[] buf;
        int rtcpPktLen;
        int end;
        int off = pkt.getOffset();
        LinkedList<RTCPExtendedReport> rtcpXRs = null;
        while (off < (end = pkt.getOffset() + pkt.getLength()) && (rtcpPktLen = StatisticsEngine.getLengthIfRTCP(buf = pkt.getBuffer(), off, end - off)) > 0) {
            int pt = 0xFF & buf[off + 1];
            if (pt == 207) {
                RTCPExtendedReport rtcpXR;
                try {
                    rtcpXR = new RTCPExtendedReport(buf, off, rtcpPktLen);
                }
                catch (IOException ioe) {
                    rtcpXR = null;
                }
                if (rtcpXR == null) {
                    off += rtcpPktLen;
                    continue;
                }
                int tailOff = off + rtcpPktLen;
                int tailLen = end - tailOff;
                if (tailLen > 0) {
                    System.arraycopy(buf, tailOff, buf, off, tailLen);
                }
                int oldOff = pkt.getOffset();
                pkt.shrink(rtcpPktLen);
                int newOff = pkt.getOffset();
                off = off - oldOff + newOff;
                if (rtcpXRs == null) {
                    rtcpXRs = new LinkedList<RTCPExtendedReport>();
                }
                rtcpXRs.add(rtcpXR);
                continue;
            }
            off += rtcpPktLen;
        }
        return rtcpXRs;
    }

    public StatisticsEngine(MediaStreamImpl stream) {
        this.mediaStream = stream;
        this.mediaType = this.mediaStream.getMediaType();
    }

    private boolean addRTCPExtendedReport(RawPacket pkt, RTCPExtendedReport extendedReport) {
        int rtcpPktLen;
        int off;
        byte[] buf = pkt.getBuffer();
        int end = off + pkt.getLength();
        for (off = pkt.getOffset(); off < end && (rtcpPktLen = StatisticsEngine.getLengthIfRTCP(buf, off, end - off)) > 0; off += rtcpPktLen) {
            int pt = 0xFF & buf[off + 1];
            boolean before = false;
            if (pt == 203) {
                int sc = 0x1F & buf[off];
                if (sc < 0 || rtcpPktLen < (1 + sc) * 4) {
                    before = true;
                } else {
                    int i = 0;
                    int ssrcOff = off + 4;
                    while (i < sc) {
                        if (RTPTranslatorImpl.readInt(buf, ssrcOff) == extendedReport.getSSRC()) {
                            before = true;
                            break;
                        }
                        ++i;
                        ssrcOff += 4;
                    }
                }
            }
            if (before) break;
        }
        boolean added = false;
        if (off <= end) {
            int extendedReportLen = extendedReport.calcLength();
            int oldOff = pkt.getOffset();
            pkt.grow(extendedReportLen);
            int newOff = pkt.getOffset();
            buf = pkt.getBuffer();
            off = off - oldOff + newOff;
            end = newOff + pkt.getLength();
            if (off < end) {
                System.arraycopy(buf, off, buf, off + extendedReportLen, end - off);
            }
            DataOutputStream dataoutputstream = new DataOutputStream(new ByteBufferOutputStream(buf, off, extendedReportLen));
            try {
                extendedReport.assemble(dataoutputstream);
                added = dataoutputstream.size() == extendedReportLen;
            }
            catch (IOException e) {
                // empty catch block
            }
            if (added) {
                pkt.setLength(pkt.getLength() + extendedReportLen);
            } else if (off < end) {
                System.arraycopy(buf, off + extendedReportLen, buf, off, end - off);
            }
        }
        return added;
    }

    private List<RTCPExtendedReport> addRTCPExtendedReports(RawPacket pkt, String sdpParams) {
        int rtcpPktLen;
        int off;
        byte[] buf = pkt.getBuffer();
        LinkedList<RTCPExtendedReport> rtcpXRs = null;
        int end = off + pkt.getLength();
        for (off = pkt.getOffset(); off < end && (rtcpPktLen = StatisticsEngine.getLengthIfRTCP(buf, off, end - off)) > 0; off += rtcpPktLen) {
            int pt = 0xFF & buf[off + 1];
            if (pt != 201 && pt != 200) continue;
            int rc = 0x1F & buf[off];
            if (rc >= 0) {
                int minRTCPPktLen = (2 + rc * 6) * 4;
                int receptionReportBlockOff = off + 8;
                if (pt == 200) {
                    minRTCPPktLen += 20;
                    receptionReportBlockOff += 20;
                }
                if (rtcpPktLen < minRTCPPktLen) {
                    rtcpXRs = null;
                    break;
                }
                int senderSSRC = RTPTranslatorImpl.readInt(buf, off + 4);
                int[] sourceSSRCs = new int[rc];
                for (int i = 0; i < rc; ++i) {
                    sourceSSRCs[i] = RTPTranslatorImpl.readInt(buf, receptionReportBlockOff);
                    receptionReportBlockOff += 24;
                }
                RTCPExtendedReport rtcpXR = this.createRTCPExtendedReport(senderSSRC, sourceSSRCs, sdpParams);
                if (rtcpXR == null) continue;
                if (rtcpXRs == null) {
                    rtcpXRs = new LinkedList<RTCPExtendedReport>();
                }
                rtcpXRs.add(rtcpXR);
                continue;
            }
            rtcpXRs = null;
            break;
        }
        if (rtcpXRs != null && !rtcpXRs.isEmpty()) {
            for (RTCPExtendedReport rtcpXR : rtcpXRs) {
                this.addRTCPExtendedReport(pkt, rtcpXR);
            }
        }
        return rtcpXRs;
    }

    @Override
    public void close() {
    }

    private RTCPExtendedReport createRTCPExtendedReport(int senderSSRC, int[] sourceSSRCs, String sdpParams) {
        RTCPExtendedReport xr = null;
        if (sourceSSRCs != null && sourceSSRCs.length != 0 && sdpParams != null && sdpParams.contains("voip-metrics")) {
            xr = new RTCPExtendedReport();
            for (int sourceSSRC : sourceSSRCs) {
                RTCPExtendedReport.VoIPMetricsReportBlock reportBlock = this.createVoIPMetricsReportBlock(senderSSRC, sourceSSRC);
                if (reportBlock == null) continue;
                xr.addReportBlock(reportBlock);
            }
            if (xr.getReportBlockCount() > 0) {
                xr.setSSRC(senderSSRC);
            } else {
                xr = null;
            }
        }
        return xr;
    }

    private RTCPExtendedReport.VoIPMetricsReportBlock createVoIPMetricsReportBlock(int senderSSRC, int sourceSSRC) {
        ReceiveStream receiveStream;
        RTCPExtendedReport.VoIPMetricsReportBlock voipMetrics = null;
        if (MediaType.AUDIO.equals((Object)this.mediaType) && (receiveStream = this.mediaStream.getReceiveStream(sourceSSRC)) != null) {
            voipMetrics = this.createVoIPMetricsReportBlock(senderSSRC, receiveStream);
        }
        return voipMetrics;
    }

    private RTCPExtendedReport.VoIPMetricsReportBlock createVoIPMetricsReportBlock(int senderSSRC, ReceiveStream receiveStream) {
        String encoding;
        double lossRate;
        long lostPacketCount;
        SSRCInfo ssrcInfo;
        RTCPExtendedReport.VoIPMetricsReportBlock voipMetrics = new RTCPExtendedReport.VoIPMetricsReportBlock();
        voipMetrics.setSourceSSRC((int)receiveStream.getSSRC());
        long expectedPacketCount = 0L;
        ReceptionStats receptionStats = receiveStream.getSourceReceptionStats();
        if (receiveStream instanceof SSRCInfo && (expectedPacketCount = (ssrcInfo = (SSRCInfo)((Object)receiveStream)).getExpectedPacketCount()) > 0L && (lostPacketCount = (long)receptionStats.getPDUlost()) > 0L && lostPacketCount <= expectedPacketCount) {
            long fecDecodedPacketCount = this.getFECDecodedPacketCount(receiveStream);
            if (fecDecodedPacketCount > 0L && fecDecodedPacketCount <= lostPacketCount) {
                lostPacketCount -= fecDecodedPacketCount;
            }
            if ((lossRate = (double)lostPacketCount / (double)expectedPacketCount * 256.0) > 255.0) {
                lossRate = 255.0;
            }
            voipMetrics.setLossRate((short)lossRate);
        }
        if (receiveStream instanceof RecvSSRCInfo) {
            voipMetrics.setRoundTripDelay(((RecvSSRCInfo)receiveStream).getRoundTripDelay(senderSSRC));
        }
        int packetLossConcealment = 1;
        MediaFormat mediaFormat = this.mediaStream.getFormat();
        if (mediaFormat != null && (encoding = mediaFormat.getEncoding()) != null) {
            encoding = encoding.toLowerCase();
            if ("opus/rtp".toLowerCase().contains(encoding) || "SILK/rtp".toLowerCase().contains(encoding)) {
                packetLossConcealment = 3;
            }
        }
        voipMetrics.setPacketLossConcealment((byte)packetLossConcealment);
        JitterBufferControl jbc = MediaStreamStatsImpl.getJitterBufferControl(receiveStream);
        if (jbc == null) {
            voipMetrics.setJitterBufferAdaptive((byte)0);
        } else {
            int discardedPacketCount;
            if (expectedPacketCount > 0L && (discardedPacketCount = jbc.getDiscarded()) > 0 && (long)discardedPacketCount <= expectedPacketCount) {
                double discardRate = (double)discardedPacketCount / (double)expectedPacketCount * 256.0;
                if (discardRate > 255.0) {
                    discardRate = 255.0;
                }
                voipMetrics.setDiscardRate((short)discardRate);
            }
            int maximumDelay = jbc.getMaximumDelay();
            voipMetrics.setJitterBufferMaximumDelay(maximumDelay);
            voipMetrics.setJitterBufferNominalDelay(jbc.getNominalDelay());
            if (jbc.isAdaptiveBufferEnabled()) {
                voipMetrics.setJitterBufferAdaptive((byte)3);
                voipMetrics.setJitterBufferAbsoluteMaximumDelay(jbc.getAbsoluteMaximumDelay());
            } else {
                voipMetrics.setJitterBufferAdaptive((byte)2);
                voipMetrics.setJitterBufferAbsoluteMaximumDelay(maximumDelay);
            }
        }
        if (receptionStats instanceof RTPStats) {
            RTPStats rtpStats = (RTPStats)receptionStats;
            BurstMetrics burstMetrics = rtpStats.getBurstMetrics();
            long l = burstMetrics.getBurstMetrics();
            int gapDuration = (int)(l & 0xFFFFL);
            int burstDuration = (int)((l >>= 16) & 0xFFFFL);
            short gapDensity = (short)((l >>= 16) & 0xFFL);
            short burstDensity = (short)((l >>= 8) & 0xFFL);
            double discardRate = (l >>= 8) & 0xFFL;
            lossRate = (l >>= 8) & 0xFFL;
            voipMetrics.setBurstDensity(burstDensity);
            voipMetrics.setGapDensity(gapDensity);
            voipMetrics.setBurstDuration(burstDuration);
            voipMetrics.setGapDuration(gapDuration);
            voipMetrics.setGMin(burstMetrics.getGMin());
        }
        return voipMetrics;
    }

    private long getFECDecodedPacketCount(ReceiveStream receiveStream) {
        MediaDeviceSession devSession = this.mediaStream.getDeviceSession();
        long fecDecodedPacketCount = 0L;
        if (devSession != null) {
            Set<FECDecoderControl> decoderControls = devSession.getDecoderControls(receiveStream, FECDecoderControl.class);
            for (FECDecoderControl decoderControl : decoderControls) {
                fecDecodedPacketCount += (long)decoderControl.fecPacketsDecoded();
            }
        }
        return fecDecodedPacketCount;
    }

    public long getLost() {
        return this.lost;
    }

    public long getMaxInterArrivalJitter() {
        return this.maxInterArrivalJitter;
    }

    public long getMinInterArrivalJitter() {
        return this.minInterArrivalJitter;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return null;
    }

    private RTCPReport parseRTCPReport(RawPacket pkt) throws IOException {
        switch (pkt.getRTCPPacketType()) {
            case 201: {
                return new RTCPReceiverReport(pkt.getBuffer(), pkt.getOffset(), pkt.getLength());
            }
            case 200: {
                return new RTCPSenderReport(pkt.getBuffer(), pkt.getOffset(), pkt.getLength());
            }
        }
        return null;
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        if (StatisticsEngine.isRTCP(pkt)) {
            List<RTCPExtendedReport> xrs;
            block9: {
                xrs = StatisticsEngine.removeRTCPExtendedReports(pkt);
                if (StatisticsEngine.isRTCP(pkt)) {
                    try {
                        this.updateReceivedMediaStreamStats(pkt);
                    }
                    catch (Throwable t) {
                        if (t instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                            break block9;
                        }
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.error("Failed to analyze an incoming RTCP packet for the purposes of statistics.", t);
                    }
                } else {
                    pkt = null;
                }
            }
            if (xrs != null) {
                RTCPReports rtcpReports = this.mediaStream.getMediaStreamStats().getRTCPReports();
                for (RTCPExtendedReport xr : xrs) {
                    rtcpReports.rtcpExtendedReportReceived(xr);
                }
            }
        }
        return pkt;
    }

    @Override
    public RawPacket transform(RawPacket pkt) {
        if (StatisticsEngine.isRTCP(pkt)) {
            List<RTCPExtendedReport> xrs;
            String sdpParams;
            Object o;
            try {
                this.updateSentMediaStreamStats(pkt);
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.error("Failed to analyze an outgoing RTCP packet for the purposes of statistics.", t);
            }
            if (MediaType.AUDIO.equals((Object)this.mediaType) && (o = this.mediaStream.getProperty("rtcp-xr")) != null && (sdpParams = o.toString()) != null && sdpParams.length() != 0 && (xrs = this.addRTCPExtendedReports(pkt, sdpParams)) != null) {
                RTCPReports rtcpReports = this.mediaStream.getMediaStreamStats().getRTCPReports();
                for (RTCPExtendedReport xr : xrs) {
                    rtcpReports.rtcpExtendedReportSent(xr);
                }
            }
        }
        return pkt;
    }

    private void updateReceivedMediaStreamStats(RawPacket pkt) throws Exception {
        RTCPReport r = this.parseRTCPReport(pkt);
        if (r != null) {
            this.mediaStream.getMediaStreamStats().getRTCPReports().rtcpReportReceived(r);
        }
    }

    private void updateSentMediaStreamStats(RawPacket pkt) throws Exception {
        RTCPReport r = this.parseRTCPReport(pkt);
        if (r != null) {
            this.mediaStream.getMediaStreamStats().getRTCPReports().rtcpReportSent(r);
            if (logger.isTraceEnabled()) {
                ++this.numberOfRTCPReports;
                Vector<RTCPFeedback> feedbackReports = r.getFeedbackReports();
                if (!feedbackReports.isEmpty()) {
                    RTCPFeedback feedback = (RTCPFeedback)feedbackReports.get(0);
                    long jitter = feedback.getJitter();
                    if (jitter < this.getMinInterArrivalJitter() || this.getMinInterArrivalJitter() == -1L) {
                        this.minInterArrivalJitter = jitter;
                    }
                    if (this.getMaxInterArrivalJitter() < jitter) {
                        this.maxInterArrivalJitter = jitter;
                    }
                    this.lost = feedback.getNumLost();
                    if (this.numberOfRTCPReports % 4L == 1L) {
                        StringBuilder buff = new StringBuilder(RTP_STAT_PREFIX);
                        String mediaTypeStr = this.mediaType == null ? "" : this.mediaType.toString();
                        buff.append("Sending a report for ").append(mediaTypeStr).append(" stream SSRC:").append(feedback.getSSRC()).append(" [");
                        if (r instanceof RTCPSenderReport) {
                            RTCPSenderReport sr = (RTCPSenderReport)r;
                            buff.append("packet count:").append(sr.getSenderPacketCount()).append(", bytes:").append(sr.getSenderByteCount()).append(", ");
                        }
                        buff.append("interarrival jitter:").append(jitter).append(", lost packets:").append(feedback.getNumLost()).append(", time since previous report:").append((int)((double)feedback.getDLSR() / 65.536)).append("ms]");
                        logger.trace(buff);
                    }
                }
            }
        }
    }
}

