/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sf.fmj.codegen.FormatTraceUtils;
import net.sf.fmj.utility.FormatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H261Format
extends VideoFormat {
    protected int stillImageTransmission = -1;
    private static String ENCODING = "h261";

    public H261Format() {
        super(ENCODING);
        this.dataType = Format.byteArray;
    }

    public H261Format(Dimension size, int maxDataLength, Class<?> dataType, float frameRate, int stillImageTransmission) {
        super(ENCODING, size, maxDataLength, dataType, frameRate);
        this.stillImageTransmission = stillImageTransmission;
    }

    @Override
    public Object clone() {
        return new H261Format(FormatUtils.clone(this.size), this.maxDataLength, this.dataType, this.frameRate, this.stillImageTransmission);
    }

    @Override
    protected void copy(Format f) {
        super.copy(f);
        H261Format oCast = (H261Format)f;
        this.stillImageTransmission = oCast.stillImageTransmission;
    }

    @Override
    public boolean equals(Object format) {
        if (!super.equals(format)) {
            return false;
        }
        if (!(format instanceof H261Format)) {
            return false;
        }
        H261Format oCast = (H261Format)format;
        return this.stillImageTransmission == oCast.stillImageTransmission;
    }

    public int getStillImageTransmission() {
        return this.stillImageTransmission;
    }

    @Override
    public Format intersects(Format other) {
        Format result = super.intersects(other);
        if (other instanceof H261Format) {
            H261Format resultCast = (H261Format)result;
            H261Format oCast = (H261Format)other;
            if (this.getClass().isAssignableFrom(other.getClass())) {
                if (FormatUtils.specified(this.stillImageTransmission)) {
                    resultCast.stillImageTransmission = this.stillImageTransmission;
                }
            } else if (other.getClass().isAssignableFrom(this.getClass()) && !FormatUtils.specified(resultCast.stillImageTransmission)) {
                resultCast.stillImageTransmission = oCast.stillImageTransmission;
            }
        }
        FormatTraceUtils.traceIntersects(this, other, result);
        return result;
    }

    @Override
    public boolean matches(Format format) {
        if (!super.matches(format)) {
            FormatTraceUtils.traceMatches(this, format, false);
            return false;
        }
        if (!(format instanceof H261Format)) {
            boolean result = true;
            FormatTraceUtils.traceMatches(this, format, true);
            return true;
        }
        H261Format oCast = (H261Format)format;
        boolean result = FormatUtils.matches(this.stillImageTransmission, oCast.stillImageTransmission);
        FormatTraceUtils.traceMatches(this, format, result);
        return result;
    }

    @Override
    public String toString() {
        return "H.261 video format";
    }
}

