/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.management.ManagementCenterService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableContext;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.partition.MigrationInfo;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.PostJoinAwareService;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.spi.ServiceInfo;
import com.hazelcast.spi.SharedService;
import com.hazelcast.spi.WaitNotifyService;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.spi.impl.BasicOperationService;
import com.hazelcast.spi.impl.EventServiceImpl;
import com.hazelcast.spi.impl.ExecutionServiceImpl;
import com.hazelcast.spi.impl.InternalOperationService;
import com.hazelcast.spi.impl.ProxyServiceImpl;
import com.hazelcast.spi.impl.ServiceManager;
import com.hazelcast.spi.impl.WaitNotifyServiceImpl;
import com.hazelcast.storage.DataRef;
import com.hazelcast.storage.Storage;
import com.hazelcast.transaction.TransactionManagerService;
import com.hazelcast.transaction.impl.TransactionManagerServiceImpl;
import com.hazelcast.wan.WanReplicationService;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;

public class NodeEngineImpl
implements NodeEngine {
    private static final int RETRY_NUMBER = 5;
    private static final int DELAY_FACTOR = 100;
    final InternalOperationService operationService;
    final ExecutionServiceImpl executionService;
    final EventServiceImpl eventService;
    final WaitNotifyServiceImpl waitNotifyService;
    private final Node node;
    private final ILogger logger;
    private final ServiceManager serviceManager;
    private final TransactionManagerServiceImpl transactionManagerService;
    private final ProxyServiceImpl proxyService;
    private final WanReplicationService wanReplicationService;

    public NodeEngineImpl(Node node) {
        this.node = node;
        this.logger = node.getLogger(NodeEngine.class.getName());
        this.proxyService = new ProxyServiceImpl(this);
        this.serviceManager = new ServiceManager(this);
        this.executionService = new ExecutionServiceImpl(this);
        this.operationService = new BasicOperationService(this);
        this.eventService = new EventServiceImpl(this);
        this.waitNotifyService = new WaitNotifyServiceImpl(this);
        this.transactionManagerService = new TransactionManagerServiceImpl(this);
        this.wanReplicationService = node.initializer.geWanReplicationService();
    }

    @PrivateApi
    public void start() {
        this.serviceManager.start();
        this.proxyService.init();
    }

    @Override
    public Address getThisAddress() {
        return this.node.getThisAddress();
    }

    @Override
    public Address getMasterAddress() {
        return this.node.getMasterAddress();
    }

    @Override
    public MemberImpl getLocalMember() {
        return this.node.getLocalMember();
    }

    @Override
    public Config getConfig() {
        return this.node.getConfig();
    }

    @Override
    public ClassLoader getConfigClassLoader() {
        return this.node.getConfigClassLoader();
    }

    @Override
    public EventService getEventService() {
        return this.eventService;
    }

    @Override
    public SerializationService getSerializationService() {
        return this.node.getSerializationService();
    }

    public PortableContext getPortableContext() {
        return this.node.getSerializationService().getPortableContext();
    }

    @Override
    public OperationService getOperationService() {
        return this.operationService;
    }

    @Override
    public ExecutionService getExecutionService() {
        return this.executionService;
    }

    @Override
    public InternalPartitionService getPartitionService() {
        return this.node.getPartitionService();
    }

    @Override
    public ClusterService getClusterService() {
        return this.node.getClusterService();
    }

    public ManagementCenterService getManagementCenterService() {
        return this.node.getManagementCenterService();
    }

    @Override
    public ProxyService getProxyService() {
        return this.proxyService;
    }

    @Override
    public WaitNotifyService getWaitNotifyService() {
        return this.waitNotifyService;
    }

    @Override
    public WanReplicationService getWanReplicationService() {
        return this.wanReplicationService;
    }

    @Override
    public TransactionManagerService getTransactionManagerService() {
        return this.transactionManagerService;
    }

    @Override
    public Data toData(Object object) {
        return this.node.getSerializationService().toData(object);
    }

    public Object toObject(Object object) {
        if (object instanceof Data) {
            return this.node.getSerializationService().toObject((Data)object);
        }
        return object;
    }

    @Override
    public boolean isActive() {
        return this.node.isActive();
    }

    @Override
    public HazelcastInstance getHazelcastInstance() {
        return this.node.hazelcastInstance;
    }

    public boolean send(Packet packet, Connection connection) {
        if (connection == null || !connection.live()) {
            return false;
        }
        MemberImpl memberImpl = this.node.getClusterService().getMember(connection.getEndPoint());
        if (memberImpl != null) {
            memberImpl.didWrite();
        }
        return connection.write(packet);
    }

    public boolean send(Packet packet, Address target) {
        return this.send(packet, target, null);
    }

    private boolean send(Packet packet, Address target, SendTask sendTask) {
        int retries;
        ConnectionManager connectionManager = this.node.getConnectionManager();
        Connection connection = connectionManager.getConnection(target);
        if (connection != null) {
            return this.send(packet, connection);
        }
        if (sendTask == null) {
            sendTask = new SendTask(packet, target);
        }
        if ((retries = sendTask.retries) < 5 && this.node.isActive()) {
            connectionManager.getOrConnect(target, true);
            this.executionService.schedule(sendTask, (retries + 1) * 100, TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    @Override
    public ILogger getLogger(String name) {
        return this.node.getLogger(name);
    }

    @Override
    public ILogger getLogger(Class clazz) {
        return this.node.getLogger(clazz);
    }

    @Override
    public GroupProperties getGroupProperties() {
        return this.node.getGroupProperties();
    }

    @PrivateApi
    public void handlePacket(Packet packet) {
        if (packet.isHeaderSet(0)) {
            this.operationService.executeOperation(packet);
        } else if (packet.isHeaderSet(2)) {
            this.eventService.handleEvent(packet);
        } else if (packet.isHeaderSet(3)) {
            this.wanReplicationService.handleEvent(packet);
        } else {
            this.logger.severe("Unknown packet type! Header: " + packet.getHeader());
        }
    }

    @PrivateApi
    public <T> T getService(String serviceName) {
        ServiceInfo serviceInfo = this.serviceManager.getServiceInfo(serviceName);
        return (T)(serviceInfo != null ? serviceInfo.getService() : null);
    }

    @Override
    public <T extends SharedService> T getSharedService(String serviceName) {
        T service = this.getService(serviceName);
        if (service == null) {
            return null;
        }
        if (service instanceof SharedService) {
            return (T)((SharedService)service);
        }
        throw new IllegalArgumentException("No SharedService registered with name: " + serviceName);
    }

    @PrivateApi
    public <S> Collection<S> getServices(Class<S> serviceClass) {
        return this.serviceManager.getServices(serviceClass);
    }

    @PrivateApi
    public Collection<ServiceInfo> getServiceInfos(Class serviceClass) {
        return this.serviceManager.getServiceInfos(serviceClass);
    }

    @PrivateApi
    public Node getNode() {
        return this.node;
    }

    @PrivateApi
    public void onMemberLeft(MemberImpl member) {
        this.waitNotifyService.onMemberLeft(member);
        this.operationService.onMemberLeft(member);
        this.eventService.onMemberLeft(member);
    }

    @PrivateApi
    public void onClientDisconnected(String clientUuid) {
        this.waitNotifyService.onClientDisconnected(clientUuid);
    }

    @PrivateApi
    public void onPartitionMigrate(MigrationInfo migrationInfo) {
        this.waitNotifyService.onPartitionMigrate(this.getThisAddress(), migrationInfo);
    }

    @PrivateApi
    public Operation[] getPostJoinOperations() {
        LinkedList<Operation> postJoinOps = new LinkedList<Operation>();
        EventServiceImpl.PostJoinRegistrationOperation eventPostJoinOp = this.eventService.getPostJoinOperation();
        if (eventPostJoinOp != null) {
            postJoinOps.add(eventPostJoinOp);
        }
        Collection<PostJoinAwareService> services = this.getServices(PostJoinAwareService.class);
        for (PostJoinAwareService service : services) {
            Operation pjOp = service.getPostJoinOperation();
            if (pjOp == null) continue;
            if (pjOp instanceof PartitionAwareOperation) {
                this.logger.severe("Post-join operations cannot implement PartitionAwareOperation! Service: " + service + ", Operation: " + pjOp);
                continue;
            }
            postJoinOps.add(pjOp);
        }
        return postJoinOps.isEmpty() ? null : postJoinOps.toArray(new Operation[postJoinOps.size()]);
    }

    public long getClusterTime() {
        return this.node.getClusterService().getClusterTime();
    }

    @Override
    public Storage<DataRef> getOffHeapStorage() {
        return this.node.initializer.getOffHeapStorage();
    }

    @PrivateApi
    public void shutdown(boolean terminate) {
        this.logger.finest("Shutting down services...");
        this.waitNotifyService.shutdown();
        this.proxyService.shutdown();
        this.serviceManager.shutdown(terminate);
        this.eventService.shutdown();
        this.operationService.shutdown();
        this.wanReplicationService.shutdown();
        this.executionService.shutdown();
    }

    private final class SendTask
    implements Runnable {
        private final Packet packet;
        private final Address target;
        private volatile int retries;

        private SendTask(Packet packet, Address target) {
            this.packet = packet;
            this.target = target;
        }

        @Override
        @SuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
        public void run() {
            ++this.retries;
            if (NodeEngineImpl.this.logger.isFinestEnabled()) {
                NodeEngineImpl.this.logger.finest("Retrying[" + this.retries + "] packet send operation to: " + this.target);
            }
            NodeEngineImpl.this.send(this.packet, this.target, this);
        }
    }
}

