/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.operations.client;

import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.multimap.impl.operations.MultiMapOperationFactory;
import com.hazelcast.multimap.impl.operations.client.MultiMapAllPartitionRequest;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.util.Map;

public class ContainsRequest
extends MultiMapAllPartitionRequest
implements RetryableRequest {
    Data value;

    public ContainsRequest() {
    }

    public ContainsRequest(String name, Data value) {
        super(name);
        this.value = value;
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new MultiMapOperationFactory(this.name, MultiMapOperationFactory.OperationFactoryType.CONTAINS, null, this.value);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        for (Object obj : map.values()) {
            if (!Boolean.TRUE.equals(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        IOUtil.writeNullableData(out, this.value);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.value = IOUtil.readNullableData(in);
    }

    @Override
    public String getMethodName() {
        return "containsValue";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.value};
    }
}

