/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl;

import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStore;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.multimap.impl.MultiMapRecord;
import com.hazelcast.multimap.impl.MultiMapService;
import com.hazelcast.multimap.impl.MultiMapWrapper;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.Clock;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class MultiMapContainer {
    private static final AtomicLongFieldUpdater<MultiMapContainer> ID_GEN_UPDATER = AtomicLongFieldUpdater.newUpdater(MultiMapContainer.class, "idGen");
    private static final AtomicLongFieldUpdater<MultiMapContainer> LAST_ACCCESS_TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(MultiMapContainer.class, "lastAccessTime");
    private static final AtomicLongFieldUpdater<MultiMapContainer> LAST_UPDATE_TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(MultiMapContainer.class, "lastUpdateTime");
    private final String name;
    private final MultiMapService service;
    private final NodeEngine nodeEngine;
    private final MultiMapConfig config;
    private final ConcurrentMap<Data, MultiMapWrapper> multiMapWrappers = new ConcurrentHashMap<Data, MultiMapWrapper>(1000);
    private final DefaultObjectNamespace lockNamespace;
    private final LockStore lockStore;
    private final int partitionId;
    private final long creationTime;
    private volatile long idGen;
    private volatile long lastAccessTime;
    private volatile long lastUpdateTime;

    public MultiMapContainer(String name, MultiMapService service, int partitionId) {
        this.name = name;
        this.service = service;
        this.nodeEngine = service.getNodeEngine();
        this.partitionId = partitionId;
        this.config = this.nodeEngine.getConfig().findMultiMapConfig(name);
        this.lockNamespace = new DefaultObjectNamespace("hz:impl:multiMapService", name);
        LockService lockService = (LockService)this.nodeEngine.getSharedService("hz:impl:lockService");
        this.lockStore = lockService == null ? null : lockService.createLockStore(partitionId, this.lockNamespace);
        this.creationTime = Clock.currentTimeMillis();
    }

    public boolean canAcquireLock(Data dataKey, String caller, long threadId) {
        return this.lockStore != null && this.lockStore.canAcquireLock(dataKey, caller, threadId);
    }

    public boolean isLocked(Data dataKey) {
        return this.lockStore != null && this.lockStore.isLocked(dataKey);
    }

    public boolean txnLock(Data key, String caller, long threadId, long ttl) {
        return this.lockStore != null && this.lockStore.txnLock(key, caller, threadId, ttl);
    }

    public boolean unlock(Data key, String caller, long threadId) {
        return this.lockStore != null && this.lockStore.unlock(key, caller, threadId);
    }

    public boolean forceUnlock(Data key) {
        return this.lockStore != null && this.lockStore.forceUnlock(key);
    }

    public boolean extendLock(Data key, String caller, long threadId, long ttl) {
        return this.lockStore != null && this.lockStore.extendLeaseTime(key, caller, threadId, ttl);
    }

    public String getLockOwnerInfo(Data dataKey) {
        return this.lockStore != null ? this.lockStore.getOwnerInfo(dataKey) : null;
    }

    public long nextId() {
        return ID_GEN_UPDATER.getAndIncrement(this);
    }

    public MultiMapWrapper getOrCreateMultiMapWrapper(Data dataKey) {
        MultiMapWrapper wrapper = (MultiMapWrapper)this.multiMapWrappers.get(dataKey);
        if (wrapper == null) {
            AbstractCollection coll;
            if (this.config.getValueCollectionType().equals((Object)MultiMapConfig.ValueCollectionType.SET)) {
                coll = new HashSet<MultiMapRecord>();
            } else if (this.config.getValueCollectionType().equals((Object)MultiMapConfig.ValueCollectionType.LIST)) {
                coll = new LinkedList();
            } else {
                throw new IllegalArgumentException("No Matching CollectionProxyType!");
            }
            wrapper = new MultiMapWrapper(coll);
            this.multiMapWrappers.put(dataKey, wrapper);
        }
        return wrapper;
    }

    public MultiMapWrapper getMultiMapWrapper(Data dataKey) {
        return (MultiMapWrapper)this.multiMapWrappers.get(dataKey);
    }

    public void delete(Data dataKey) {
        this.multiMapWrappers.remove(dataKey);
    }

    public Collection<MultiMapRecord> remove(Data dataKey, boolean copyOf) {
        MultiMapWrapper wrapper = (MultiMapWrapper)this.multiMapWrappers.remove(dataKey);
        return wrapper != null ? wrapper.getCollection(copyOf) : null;
    }

    public Set<Data> keySet() {
        Set keySet = this.multiMapWrappers.keySet();
        HashSet<Data> keys = new HashSet<Data>(keySet.size());
        keys.addAll(keySet);
        return keys;
    }

    public Collection<MultiMapRecord> values() {
        LinkedList<MultiMapRecord> valueCollection = new LinkedList<MultiMapRecord>();
        for (MultiMapWrapper wrapper : this.multiMapWrappers.values()) {
            valueCollection.addAll(wrapper.getCollection(false));
        }
        return valueCollection;
    }

    public boolean containsKey(Data key) {
        return this.multiMapWrappers.containsKey(key);
    }

    public boolean containsEntry(boolean binary, Data key, Data value) {
        MultiMapWrapper wrapper = (MultiMapWrapper)this.multiMapWrappers.get(key);
        if (wrapper == null) {
            return false;
        }
        MultiMapRecord record = new MultiMapRecord(binary ? value : this.nodeEngine.toObject(value));
        return wrapper.getCollection(false).contains(record);
    }

    public boolean containsValue(boolean binary, Data value) {
        for (Data key : this.multiMapWrappers.keySet()) {
            if (!this.containsEntry(binary, key, value)) continue;
            return true;
        }
        return false;
    }

    public Map<Data, Collection<MultiMapRecord>> copyCollections() {
        HashMap<Data, Collection<MultiMapRecord>> map = new HashMap<Data, Collection<MultiMapRecord>>(this.multiMapWrappers.size());
        for (Map.Entry entry : this.multiMapWrappers.entrySet()) {
            Data key = (Data)entry.getKey();
            Collection<MultiMapRecord> col = ((MultiMapWrapper)entry.getValue()).getCollection(true);
            map.put(key, col);
        }
        return map;
    }

    public int size() {
        int size = 0;
        for (MultiMapWrapper wrapper : this.multiMapWrappers.values()) {
            size += wrapper.getCollection(false).size();
        }
        return size;
    }

    public int clear() {
        Set<Data> locks = this.lockStore != null ? this.lockStore.getLockedKeys() : Collections.emptySet();
        HashMap<Data, MultiMapWrapper> lockedKeys = new HashMap<Data, MultiMapWrapper>(locks.size());
        for (Data key : locks) {
            MultiMapWrapper wrapper = (MultiMapWrapper)this.multiMapWrappers.get(key);
            if (wrapper == null) continue;
            lockedKeys.put(key, wrapper);
        }
        int numberOfAffectedEntries = this.multiMapWrappers.size() - lockedKeys.size();
        this.multiMapWrappers.clear();
        this.multiMapWrappers.putAll(lockedKeys);
        return numberOfAffectedEntries;
    }

    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    public MultiMapConfig getConfig() {
        return this.config;
    }

    public void destroy() {
        LockService lockService = (LockService)this.nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            lockService.clearLockStore(this.partitionId, this.lockNamespace);
        }
        this.multiMapWrappers.clear();
    }

    public void access() {
        LAST_ACCCESS_TIME_UPDATER.set(this, Clock.currentTimeMillis());
    }

    public void update() {
        LAST_UPDATE_TIME_UPDATER.set(this, Clock.currentTimeMillis());
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLockedCount() {
        return this.lockStore.getLockedKeys().size();
    }

    public ConcurrentMap<Data, MultiMapWrapper> getMultiMapWrappers() {
        return this.multiMapWrappers;
    }
}

