/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.MapService;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;

public class ContainsValueOperation
extends AbstractMapOperation
implements PartitionAwareOperation {
    private boolean contains;
    private Data testValue;

    public ContainsValueOperation(String name, Data testValue) {
        super(name);
        this.testValue = testValue;
    }

    public ContainsValueOperation() {
    }

    @Override
    public void run() {
        MapService mapService = (MapService)this.getService();
        RecordStore recordStore = mapService.getMapServiceContext().getRecordStore(this.getPartitionId(), this.name);
        this.contains = recordStore.containsValue(this.testValue);
        if (this.mapContainer.getMapConfig().isStatisticsEnabled()) {
            ((MapService)this.getService()).getMapServiceContext().getLocalMapStatsProvider().getLocalMapStatsImpl(this.name).incrementOtherOperations();
        }
    }

    @Override
    public Object getResponse() {
        return this.contains;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        IOUtil.writeNullableData(out, this.testValue);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.testValue = IOUtil.readNullableData(in);
    }
}

