/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.proxy.MapProxyImpl;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.RemoteService;
import java.util.Map;

class MapRemoteService
implements RemoteService {
    private final MapServiceContext mapServiceContext;
    private final NodeEngine nodeEngine;

    public MapRemoteService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
    }

    @Override
    public MapProxyImpl createDistributedObject(String name) {
        return new MapProxyImpl(name, this.mapServiceContext.getService(), this.nodeEngine);
    }

    @Override
    public void destroyDistributedObject(String name) {
        Map<String, MapContainer> mapContainers = this.mapServiceContext.getMapContainers();
        MapContainer mapContainer = mapContainers.remove(name);
        if (mapContainer != null) {
            if (mapContainer.isNearCacheEnabled()) {
                this.mapServiceContext.getNearCacheProvider().remove(name);
            }
            mapContainer.getMapStoreManager().stop();
        }
        this.mapServiceContext.destroyMap(name);
        this.nodeEngine.getEventService().deregisterAllListeners(this.mapServiceContext.serviceName(), name);
    }
}

