/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.cache.impl.CacheDistributedObject;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.CacheStatisticsImpl;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.Partition;
import com.hazelcast.core.PartitionService;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.management.SerializableClientEndPoint;
import com.hazelcast.management.SerializableConnectionManagerBean;
import com.hazelcast.management.SerializableEventServiceBean;
import com.hazelcast.management.SerializableMXBeans;
import com.hazelcast.management.SerializableManagedExecutorBean;
import com.hazelcast.management.SerializableOperationServiceBean;
import com.hazelcast.management.SerializablePartitionServiceBean;
import com.hazelcast.management.SerializableProxyServiceBean;
import com.hazelcast.monitor.TimedMemberState;
import com.hazelcast.monitor.impl.LocalCacheStatsImpl;
import com.hazelcast.monitor.impl.LocalExecutorStatsImpl;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.monitor.impl.LocalMultiMapStatsImpl;
import com.hazelcast.monitor.impl.LocalQueueStatsImpl;
import com.hazelcast.monitor.impl.LocalTopicStatsImpl;
import com.hazelcast.monitor.impl.MemberStateImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.util.executor.ManagedExecutorService;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TimedMemberStateFactory {
    private static final int PERCENT_MULTIPLIER = 100;
    private static final ILogger LOGGER = Logger.getLogger(TimedMemberStateFactory.class);
    private final HazelcastInstanceImpl instance;
    private final int maxVisibleInstanceCount;
    private final boolean cacheServiceEnabled;

    public TimedMemberStateFactory(HazelcastInstanceImpl instance) {
        this.instance = instance;
        this.maxVisibleInstanceCount = instance.node.groupProperties.MC_MAX_INSTANCE_COUNT.getInteger();
        this.cacheServiceEnabled = instance.node.nodeEngine.getService("hz:impl:cacheService") != null;
    }

    public TimedMemberState createTimedMemberState() {
        MemberStateImpl memberState = new MemberStateImpl();
        this.createMemberState(memberState);
        GroupConfig groupConfig = this.instance.getConfig().getGroupConfig();
        TimedMemberState timedMemberState = new TimedMemberState();
        timedMemberState.setMaster(this.instance.node.isMaster());
        timedMemberState.setMemberList(new ArrayList<String>());
        if (timedMemberState.getMaster().booleanValue()) {
            Set<Member> memberSet = this.instance.getCluster().getMembers();
            for (Member member : memberSet) {
                MemberImpl memberImpl = (MemberImpl)member;
                Address address = memberImpl.getAddress();
                timedMemberState.getMemberList().add(address.getHost() + ":" + address.getPort());
            }
        }
        timedMemberState.setMemberState(memberState);
        timedMemberState.setClusterName(groupConfig.getName());
        timedMemberState.setInstanceNames(this.getLongInstanceNames());
        return timedMemberState;
    }

    private void createMemberState(MemberStateImpl memberState) {
        Node node = this.instance.node;
        HashSet<SerializableClientEndPoint> serializableClientEndPoints = new HashSet<SerializableClientEndPoint>();
        for (Client client : this.instance.node.clientEngine.getClients()) {
            serializableClientEndPoints.add(new SerializableClientEndPoint(client));
        }
        memberState.setClients(serializableClientEndPoints);
        memberState.setAddress(node.getThisAddress().getHost() + ":" + node.getThisAddress().getPort());
        this.createJMXBeans(memberState);
        PartitionService partitionService = this.instance.getPartitionService();
        Set<Partition> partitions = partitionService.getPartitions();
        memberState.clearPartitions();
        for (Partition partition : partitions) {
            if (partition.getOwner() == null || !partition.getOwner().localMember()) continue;
            memberState.addPartition(partition.getPartitionId());
        }
        ArrayList<DistributedObject> proxyObjects = new ArrayList<DistributedObject>(this.instance.getDistributedObjects());
        this.createRuntimeProps(memberState);
        this.createMemState(memberState, proxyObjects);
    }

    private void createJMXBeans(MemberStateImpl memberState) {
        EventService es = this.instance.node.nodeEngine.getEventService();
        OperationService os = this.instance.node.nodeEngine.getOperationService();
        ConnectionManager cm = this.instance.node.connectionManager;
        InternalPartitionService ps = this.instance.node.partitionService;
        ProxyService proxyService = this.instance.node.nodeEngine.getProxyService();
        ExecutionService executionService = this.instance.node.nodeEngine.getExecutionService();
        SerializableMXBeans beans = new SerializableMXBeans();
        SerializableEventServiceBean esBean = new SerializableEventServiceBean(es);
        beans.setEventServiceBean(esBean);
        SerializableOperationServiceBean osBean = new SerializableOperationServiceBean(os);
        beans.setOperationServiceBean(osBean);
        SerializableConnectionManagerBean cmBean = new SerializableConnectionManagerBean(cm);
        beans.setConnectionManagerBean(cmBean);
        SerializablePartitionServiceBean psBean = new SerializablePartitionServiceBean(ps, this.instance);
        beans.setPartitionServiceBean(psBean);
        SerializableProxyServiceBean proxyServiceBean = new SerializableProxyServiceBean(proxyService);
        beans.setProxyServiceBean(proxyServiceBean);
        ManagedExecutorService systemExecutor = executionService.getExecutor("hz:system");
        ManagedExecutorService asyncExecutor = executionService.getExecutor("hz:async");
        ManagedExecutorService scheduledExecutor = executionService.getExecutor("hz:scheduled");
        ManagedExecutorService clientExecutor = executionService.getExecutor("hz:client");
        ManagedExecutorService queryExecutor = executionService.getExecutor("hz:query");
        ManagedExecutorService ioExecutor = executionService.getExecutor("hz:io");
        SerializableManagedExecutorBean systemExecutorBean = new SerializableManagedExecutorBean(systemExecutor);
        SerializableManagedExecutorBean asyncExecutorBean = new SerializableManagedExecutorBean(asyncExecutor);
        SerializableManagedExecutorBean scheduledExecutorBean = new SerializableManagedExecutorBean(scheduledExecutor);
        SerializableManagedExecutorBean clientExecutorBean = new SerializableManagedExecutorBean(clientExecutor);
        SerializableManagedExecutorBean queryExecutorBean = new SerializableManagedExecutorBean(queryExecutor);
        SerializableManagedExecutorBean ioExecutorBean = new SerializableManagedExecutorBean(ioExecutor);
        beans.putManagedExecutor("hz:system", systemExecutorBean);
        beans.putManagedExecutor("hz:async", asyncExecutorBean);
        beans.putManagedExecutor("hz:scheduled", scheduledExecutorBean);
        beans.putManagedExecutor("hz:client", clientExecutorBean);
        beans.putManagedExecutor("hz:query", queryExecutorBean);
        beans.putManagedExecutor("hz:io", ioExecutorBean);
        memberState.setBeans(beans);
    }

    private void createRuntimeProps(MemberStateImpl memberState) {
        Runtime runtime = Runtime.getRuntime();
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        ClassLoadingMXBean clMxBean = ManagementFactory.getClassLoadingMXBean();
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemory = memoryMxBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemory = memoryMxBean.getNonHeapMemoryUsage();
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("runtime.availableProcessors", Integer.valueOf(runtime.availableProcessors()).longValue());
        map.put("date.startTime", runtimeMxBean.getStartTime());
        map.put("seconds.upTime", runtimeMxBean.getUptime());
        map.put("memory.maxMemory", runtime.maxMemory());
        map.put("memory.freeMemory", runtime.freeMemory());
        map.put("memory.totalMemory", runtime.totalMemory());
        map.put("memory.heapMemoryMax", heapMemory.getMax());
        map.put("memory.heapMemoryUsed", heapMemory.getUsed());
        map.put("memory.nonHeapMemoryMax", nonHeapMemory.getMax());
        map.put("memory.nonHeapMemoryUsed", nonHeapMemory.getUsed());
        map.put("runtime.totalLoadedClassCount", clMxBean.getTotalLoadedClassCount());
        map.put("runtime.loadedClassCount", Integer.valueOf(clMxBean.getLoadedClassCount()).longValue());
        map.put("runtime.unloadedClassCount", clMxBean.getUnloadedClassCount());
        map.put("runtime.totalStartedThreadCount", threadMxBean.getTotalStartedThreadCount());
        map.put("runtime.threadCount", Integer.valueOf(threadMxBean.getThreadCount()).longValue());
        map.put("runtime.peakThreadCount", Integer.valueOf(threadMxBean.getPeakThreadCount()).longValue());
        map.put("runtime.daemonThreadCount", Integer.valueOf(threadMxBean.getDaemonThreadCount()).longValue());
        OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
        map.put("osMemory.freePhysicalMemory", TimedMemberStateFactory.get(osMxBean, "getFreePhysicalMemorySize", 0L));
        map.put("osMemory.committedVirtualMemory", TimedMemberStateFactory.get(osMxBean, "getCommittedVirtualMemorySize", 0L));
        map.put("osMemory.totalPhysicalMemory", TimedMemberStateFactory.get(osMxBean, "getTotalPhysicalMemorySize", 0L));
        map.put("osSwap.freeSwapSpace", TimedMemberStateFactory.get(osMxBean, "getFreeSwapSpaceSize", 0L));
        map.put("osSwap.totalSwapSpace", TimedMemberStateFactory.get(osMxBean, "getTotalSwapSpaceSize", 0L));
        map.put("os.maxFileDescriptorCount", TimedMemberStateFactory.get(osMxBean, "getMaxFileDescriptorCount", 0L));
        map.put("os.openFileDescriptorCount", TimedMemberStateFactory.get(osMxBean, "getOpenFileDescriptorCount", 0L));
        map.put("os.processCpuLoad", TimedMemberStateFactory.get(osMxBean, "getProcessCpuLoad", -1L));
        map.put("os.systemLoadAverage", TimedMemberStateFactory.get(osMxBean, "getSystemLoadAverage", -1L));
        map.put("os.systemCpuLoad", TimedMemberStateFactory.get(osMxBean, "getSystemCpuLoad", -1L));
        map.put("os.processCpuTime", TimedMemberStateFactory.get(osMxBean, "getProcessCpuTime", 0L));
        map.put("os.availableProcessors", TimedMemberStateFactory.get(osMxBean, "getAvailableProcessors", 0L));
        memberState.setRuntimeProps(map);
    }

    private static Long get(OperatingSystemMXBean mbean, String methodName, Long defaultValue) {
        try {
            Method method = mbean.getClass().getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            Object value = method.invoke((Object)mbean, new Object[0]);
            if (value instanceof Integer) {
                return (long)((Integer)value);
            }
            if (value instanceof Double) {
                double v = (Double)value;
                return Math.round(v * 100.0);
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            return defaultValue;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private void createMemState(MemberStateImpl memberState, Collection<DistributedObject> distributedObjects) {
        int count = 0;
        Config config = this.instance.getConfig();
        Iterator<DistributedObject> iterator = distributedObjects.iterator();
        while (iterator.hasNext() && count < this.maxVisibleInstanceCount) {
            DistributedObject distributedObject = iterator.next();
            if (distributedObject instanceof IMap) {
                count = this.handleMap(memberState, count, config, (IMap)distributedObject);
                continue;
            }
            if (distributedObject instanceof IQueue) {
                count = this.handleQueue(memberState, count, config, (IQueue)distributedObject);
                continue;
            }
            if (distributedObject instanceof ITopic) {
                count = this.handleTopic(memberState, count, config, (ITopic)distributedObject);
                continue;
            }
            if (distributedObject instanceof MultiMap) {
                count = this.handleMultimap(memberState, count, config, (MultiMap)distributedObject);
                continue;
            }
            if (distributedObject instanceof IExecutorService) {
                count = this.handleExecutorService(memberState, count, config, (IExecutorService)distributedObject);
                continue;
            }
            LOGGER.finest("Distributed object ignored for monitoring: " + distributedObject.getName());
        }
        if (this.cacheServiceEnabled) {
            CacheService cacheService = this.getCacheService();
            for (CacheConfig cacheConfig : cacheService.getCacheConfigs()) {
                if (!cacheConfig.isStatisticsEnabled()) continue;
                CacheStatisticsImpl statistics = cacheService.getStatistics(cacheConfig.getNameWithPrefix());
                count = this.handleCache(memberState, count, cacheConfig, statistics);
            }
        }
    }

    private int handleExecutorService(MemberStateImpl memberState, int count, Config config, IExecutorService executorService) {
        if (config.findExecutorConfig(executorService.getName()).isStatisticsEnabled()) {
            LocalExecutorStatsImpl stats = (LocalExecutorStatsImpl)executorService.getLocalExecutorStats();
            memberState.putLocalExecutorStats(executorService.getName(), stats);
            return count + 1;
        }
        return count;
    }

    private int handleMultimap(MemberStateImpl memberState, int count, Config config, MultiMap multiMap) {
        if (config.findMultiMapConfig(multiMap.getName()).isStatisticsEnabled()) {
            LocalMultiMapStatsImpl stats = (LocalMultiMapStatsImpl)multiMap.getLocalMultiMapStats();
            memberState.putLocalMultiMapStats(multiMap.getName(), stats);
            return count + 1;
        }
        return count;
    }

    private int handleTopic(MemberStateImpl memberState, int count, Config config, ITopic topic) {
        if (config.findTopicConfig(topic.getName()).isStatisticsEnabled()) {
            LocalTopicStatsImpl stats = (LocalTopicStatsImpl)topic.getLocalTopicStats();
            memberState.putLocalTopicStats(topic.getName(), stats);
            return count + 1;
        }
        return count;
    }

    private int handleQueue(MemberStateImpl memberState, int count, Config config, IQueue queue) {
        if (config.findQueueConfig(queue.getName()).isStatisticsEnabled()) {
            LocalQueueStatsImpl stats = (LocalQueueStatsImpl)queue.getLocalQueueStats();
            memberState.putLocalQueueStats(queue.getName(), stats);
            return count + 1;
        }
        return count;
    }

    private int handleMap(MemberStateImpl memberState, int count, Config config, IMap map) {
        if (config.findMapConfig(map.getName()).isStatisticsEnabled()) {
            memberState.putLocalMapStats(map.getName(), (LocalMapStatsImpl)map.getLocalMapStats());
            return count + 1;
        }
        return count;
    }

    private int handleCache(MemberStateImpl memberState, int count, CacheConfig config, CacheStatistics cacheStatistics) {
        memberState.putLocalCacheStats(config.getNameWithPrefix(), new LocalCacheStatsImpl(cacheStatistics));
        return count + 1;
    }

    private Set<String> getLongInstanceNames() {
        HashSet<String> setLongInstanceNames = new HashSet<String>(this.maxVisibleInstanceCount);
        ArrayList<DistributedObject> proxyObjects = new ArrayList<DistributedObject>(this.instance.getDistributedObjects());
        this.collectInstanceNames(setLongInstanceNames, proxyObjects);
        return setLongInstanceNames;
    }

    private void collectInstanceNames(Set<String> setLongInstanceNames, Collection<DistributedObject> distributedObjects) {
        int count = 0;
        Config config = this.instance.getConfig();
        for (DistributedObject distributedObject : distributedObjects) {
            if (count >= this.maxVisibleInstanceCount) continue;
            if (distributedObject instanceof MultiMap) {
                count = this.collectMultiMapName(setLongInstanceNames, count, config, (MultiMap)distributedObject);
                continue;
            }
            if (distributedObject instanceof IMap) {
                count = this.collectMapName(setLongInstanceNames, count, config, (IMap)distributedObject);
                continue;
            }
            if (distributedObject instanceof IQueue) {
                count = this.collectQueueName(setLongInstanceNames, count, config, (IQueue)distributedObject);
                continue;
            }
            if (distributedObject instanceof ITopic) {
                count = this.collectTopicName(setLongInstanceNames, count, config, (ITopic)distributedObject);
                continue;
            }
            if (distributedObject instanceof IExecutorService) {
                count = this.collectExecutorServiceName(setLongInstanceNames, count, config, (IExecutorService)distributedObject);
                continue;
            }
            LOGGER.finest("Distributed object ignored for monitoring: " + distributedObject.getName());
        }
        if (this.cacheServiceEnabled) {
            for (CacheConfig cacheConfig : this.getCacheService().getCacheConfigs()) {
                if (!cacheConfig.isStatisticsEnabled()) continue;
                count = this.collectCacheName(setLongInstanceNames, count, cacheConfig);
            }
        }
    }

    private int collectExecutorServiceName(Set<String> setLongInstanceNames, int count, Config config, IExecutorService executorService) {
        if (config.findExecutorConfig(executorService.getName()).isStatisticsEnabled()) {
            setLongInstanceNames.add("e:" + executorService.getName());
            return count + 1;
        }
        return count;
    }

    private int collectTopicName(Set<String> setLongInstanceNames, int count, Config config, ITopic topic) {
        if (config.findTopicConfig(topic.getName()).isStatisticsEnabled()) {
            setLongInstanceNames.add("t:" + topic.getName());
            return count + 1;
        }
        return count;
    }

    private int collectQueueName(Set<String> setLongInstanceNames, int count, Config config, IQueue queue) {
        if (config.findQueueConfig(queue.getName()).isStatisticsEnabled()) {
            setLongInstanceNames.add("q:" + queue.getName());
            return count + 1;
        }
        return count;
    }

    private int collectMapName(Set<String> setLongInstanceNames, int count, Config config, IMap map) {
        if (config.findMapConfig(map.getName()).isStatisticsEnabled()) {
            setLongInstanceNames.add("c:" + map.getName());
            return count + 1;
        }
        return count;
    }

    private int collectCacheName(Set<String> setLongInstanceNames, int count, CacheConfig config) {
        if (config.isStatisticsEnabled()) {
            setLongInstanceNames.add("j:" + config.getNameWithPrefix());
            return count + 1;
        }
        return count;
    }

    private int collectMultiMapName(Set<String> setLongInstanceNames, int count, Config config, MultiMap multiMap) {
        if (config.findMultiMapConfig(multiMap.getName()).isStatisticsEnabled()) {
            setLongInstanceNames.add("m:" + multiMap.getName());
            return count + 1;
        }
        return count;
    }

    private CacheService getCacheService() {
        CacheDistributedObject setupRef = (CacheDistributedObject)this.instance.getDistributedObject("hz:impl:cacheService", "setupRef");
        return (CacheService)setupRef.getService();
    }
}

