/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OutOfMemoryHandler;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.util.ValidationUtil;
import java.util.concurrent.atomic.AtomicReference;

public final class OutOfMemoryErrorDispatcher {
    private static final int MAX_REGISTERED_INSTANCES = 50;
    private static final HazelcastInstance[] EMPTY_INSTANCES = new HazelcastInstance[0];
    private static final AtomicReference<HazelcastInstance[]> INSTANCES_REF = new AtomicReference<HazelcastInstance[]>(EMPTY_INSTANCES);
    private static volatile OutOfMemoryHandler handler = new DefaultOutOfMemoryHandler();
    private static volatile OutOfMemoryHandler clientHandler;

    private OutOfMemoryErrorDispatcher() {
    }

    static HazelcastInstance[] current() {
        return INSTANCES_REF.get();
    }

    public static void setHandler(OutOfMemoryHandler outOfMemoryHandler) {
        handler = outOfMemoryHandler;
    }

    public static void setClientHandler(OutOfMemoryHandler outOfMemoryHandler) {
        clientHandler = outOfMemoryHandler;
    }

    public static void register(HazelcastInstance instance) {
        HazelcastInstance[] newInstances;
        HazelcastInstance[] oldInstances;
        ValidationUtil.isNotNull(instance, "instance");
        do {
            if ((oldInstances = INSTANCES_REF.get()).length == 50) {
                return;
            }
            newInstances = new HazelcastInstance[oldInstances.length + 1];
            System.arraycopy(oldInstances, 0, newInstances, 0, oldInstances.length);
            newInstances[oldInstances.length] = instance;
        } while (!INSTANCES_REF.compareAndSet(oldInstances, newInstances));
    }

    public static void deregister(HazelcastInstance instance) {
        HazelcastInstance[] newInstances;
        HazelcastInstance[] oldInstances;
        ValidationUtil.isNotNull(instance, "instance");
        do {
            int indexOf;
            if ((indexOf = OutOfMemoryErrorDispatcher.indexOf(oldInstances = INSTANCES_REF.get(), instance)) == -1) {
                return;
            }
            if (oldInstances.length == 1) {
                newInstances = EMPTY_INSTANCES;
                continue;
            }
            newInstances = new HazelcastInstance[oldInstances.length - 1];
            System.arraycopy(oldInstances, 0, newInstances, 0, indexOf);
            if (indexOf >= newInstances.length) continue;
            System.arraycopy(oldInstances, indexOf + 1, newInstances, indexOf, newInstances.length - indexOf);
        } while (!INSTANCES_REF.compareAndSet(oldInstances, newInstances));
    }

    private static int indexOf(HazelcastInstance[] instances, HazelcastInstance instance) {
        for (int k = 0; k < instances.length; ++k) {
            if (instance != instances[k]) continue;
            return k;
        }
        return -1;
    }

    static void clear() {
        INSTANCES_REF.set(EMPTY_INSTANCES);
    }

    public static void inspectOutputMemoryError(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof OutOfMemoryError) {
            OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)throwable);
        }
    }

    public static void onOutOfMemory(OutOfMemoryError outOfMemoryError) {
        ValidationUtil.isNotNull(outOfMemoryError, "outOfMemoryError");
        HazelcastInstance[] instances = OutOfMemoryErrorDispatcher.removeRegisteredInstances();
        if (instances.length == 0) {
            return;
        }
        OutOfMemoryHandler h = clientHandler;
        if (h != null) {
            try {
                h.onOutOfMemory(outOfMemoryError, instances);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        if ((h = handler) != null) {
            try {
                h.onOutOfMemory(outOfMemoryError, instances);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static HazelcastInstance[] removeRegisteredInstances() {
        HazelcastInstance[] instances;
        while (!INSTANCES_REF.compareAndSet(instances = INSTANCES_REF.get(), EMPTY_INSTANCES)) {
        }
        return instances;
    }

    public static final class Helper {
        private Helper() {
        }

        public static void tryCloseConnections(HazelcastInstance hazelcastInstance) {
            if (hazelcastInstance == null) {
                return;
            }
            HazelcastInstanceImpl factory = (HazelcastInstanceImpl)hazelcastInstance;
            Helper.closeSockets(factory);
        }

        private static void closeSockets(HazelcastInstanceImpl factory) {
            if (factory.node.connectionManager != null) {
                try {
                    factory.node.connectionManager.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public static void tryShutdown(HazelcastInstance hazelcastInstance) {
            if (hazelcastInstance == null) {
                return;
            }
            HazelcastInstanceImpl factory = (HazelcastInstanceImpl)hazelcastInstance;
            Helper.closeSockets(factory);
            try {
                factory.node.shutdown(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public static void inactivate(HazelcastInstance hazelcastInstance) {
            if (hazelcastInstance == null) {
                return;
            }
            HazelcastInstanceImpl factory = (HazelcastInstanceImpl)hazelcastInstance;
            factory.node.inactivate();
        }

        public static void tryStopThreads(HazelcastInstance hazelcastInstance) {
            if (hazelcastInstance == null) {
                return;
            }
            HazelcastInstanceImpl factory = (HazelcastInstanceImpl)hazelcastInstance;
            try {
                factory.node.threadGroup.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class DefaultOutOfMemoryHandler
    extends OutOfMemoryHandler {
        private DefaultOutOfMemoryHandler() {
        }

        @Override
        public void onOutOfMemory(OutOfMemoryError oom, HazelcastInstance[] hazelcastInstances) {
            for (HazelcastInstance instance : hazelcastInstances) {
                if (!(instance instanceof HazelcastInstanceImpl)) continue;
                Helper.tryCloseConnections(instance);
                Helper.tryStopThreads(instance);
                Helper.tryShutdown(instance);
            }
            System.err.println(oom);
        }
    }
}

