/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfigReadOnly;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.io.Serializable;

public class NearCacheConfig
implements DataSerializable,
Serializable {
    public static final int DEFAULT_TTL_SECONDS = 0;
    public static final int DEFAULT_MAX_IDLE_SECONDS = 0;
    public static final int DEFAULT_MAX_SIZE = Integer.MAX_VALUE;
    public static final String DEFAULT_EVICTION_POLICY = "LRU";
    public static final InMemoryFormat DEFAULT_MEMORY_FORMAT = InMemoryFormat.BINARY;
    private int timeToLiveSeconds = 0;
    private int maxSize = Integer.MAX_VALUE;
    private String evictionPolicy = "LRU";
    private int maxIdleSeconds = 0;
    private boolean invalidateOnChange = true;
    private InMemoryFormat inMemoryFormat = DEFAULT_MEMORY_FORMAT;
    private String name = "default";
    private NearCacheConfigReadOnly readOnly;
    private boolean cacheLocalEntries;
    private LocalUpdatePolicy localUpdatePolicy = LocalUpdatePolicy.INVALIDATE;

    public NearCacheConfig() {
    }

    public NearCacheConfig(int timeToLiveSeconds, int maxSize, String evictionPolicy, int maxIdleSeconds, boolean invalidateOnChange, InMemoryFormat inMemoryFormat) {
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.maxSize = maxSize;
        this.evictionPolicy = evictionPolicy;
        this.maxIdleSeconds = maxIdleSeconds;
        this.invalidateOnChange = invalidateOnChange;
        this.inMemoryFormat = inMemoryFormat;
    }

    public NearCacheConfig(NearCacheConfig config) {
        this.name = config.getName();
        this.evictionPolicy = config.getEvictionPolicy();
        this.inMemoryFormat = config.getInMemoryFormat();
        this.invalidateOnChange = config.isInvalidateOnChange();
        this.maxIdleSeconds = config.getMaxIdleSeconds();
        this.maxSize = config.getMaxSize();
        this.timeToLiveSeconds = config.getTimeToLiveSeconds();
        this.cacheLocalEntries = config.isCacheLocalEntries();
        this.localUpdatePolicy = config.localUpdatePolicy;
    }

    public NearCacheConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new NearCacheConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public String getName() {
        return this.name;
    }

    public NearCacheConfig setName(String name) {
        this.name = name;
        return this;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public NearCacheConfig setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
        return this;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public NearCacheConfig setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public String getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public NearCacheConfig setEvictionPolicy(String evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public int getMaxIdleSeconds() {
        return this.maxIdleSeconds;
    }

    public NearCacheConfig setMaxIdleSeconds(int maxIdleSeconds) {
        this.maxIdleSeconds = maxIdleSeconds;
        return this;
    }

    public boolean isInvalidateOnChange() {
        return this.invalidateOnChange;
    }

    public NearCacheConfig setInvalidateOnChange(boolean invalidateOnChange) {
        this.invalidateOnChange = invalidateOnChange;
        return this;
    }

    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    public NearCacheConfig setInMemoryFormat(InMemoryFormat inMemoryFormat) {
        this.inMemoryFormat = inMemoryFormat;
        return this;
    }

    public boolean isCacheLocalEntries() {
        return this.cacheLocalEntries;
    }

    public NearCacheConfig setCacheLocalEntries(boolean cacheLocalEntries) {
        this.cacheLocalEntries = cacheLocalEntries;
        return this;
    }

    public LocalUpdatePolicy getLocalUpdatePolicy() {
        return this.localUpdatePolicy;
    }

    public NearCacheConfig setLocalUpdatePolicy(LocalUpdatePolicy localUpdatePolicy) {
        this.localUpdatePolicy = localUpdatePolicy;
        return this;
    }

    public NearCacheConfig setInMemoryFormat(String inMemoryFormat) {
        this.inMemoryFormat = InMemoryFormat.valueOf(inMemoryFormat);
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.evictionPolicy);
        out.writeInt(this.timeToLiveSeconds);
        out.writeInt(this.maxSize);
        out.writeBoolean(this.invalidateOnChange);
        out.writeBoolean(this.cacheLocalEntries);
        out.writeInt(this.inMemoryFormat.ordinal());
        out.writeInt(this.localUpdatePolicy.ordinal());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.evictionPolicy = in.readUTF();
        this.timeToLiveSeconds = in.readInt();
        this.maxSize = in.readInt();
        this.maxSize = in.readInt();
        this.invalidateOnChange = in.readBoolean();
        this.cacheLocalEntries = in.readBoolean();
        int inMemoryFormatInt = in.readInt();
        this.inMemoryFormat = InMemoryFormat.values()[inMemoryFormatInt];
        int localUpdatePolicyInt = in.readInt();
        this.localUpdatePolicy = LocalUpdatePolicy.values()[localUpdatePolicyInt];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NearCacheConfig{");
        sb.append("timeToLiveSeconds=").append(this.timeToLiveSeconds);
        sb.append(", maxSize=").append(this.maxSize);
        sb.append(", evictionPolicy='").append(this.evictionPolicy).append('\'');
        sb.append(", maxIdleSeconds=").append(this.maxIdleSeconds);
        sb.append(", invalidateOnChange=").append(this.invalidateOnChange);
        sb.append(", inMemoryFormat=").append((Object)this.inMemoryFormat);
        sb.append(", cacheLocalEntries=").append(this.cacheLocalEntries);
        sb.append(", localUpdatePolicy=").append((Object)this.localUpdatePolicy);
        sb.append('}');
        return sb.toString();
    }

    public static enum LocalUpdatePolicy {
        INVALIDATE,
        CACHE;

    }
}

