/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.client;

import com.hazelcast.collection.CollectionCompareAndRemoveOperation;
import com.hazelcast.collection.client.CollectionRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class CollectionCompareAndRemoveRequest
extends CollectionRequest {
    private Set<Data> valueSet;
    private boolean retain;

    public CollectionCompareAndRemoveRequest() {
    }

    public CollectionCompareAndRemoveRequest(String name, Set<Data> valueSet, boolean retain) {
        super(name);
        this.valueSet = valueSet;
        this.retain = retain;
    }

    @Override
    protected Operation prepareOperation() {
        return new CollectionCompareAndRemoveOperation(this.name, this.retain, this.valueSet);
    }

    @Override
    public int getClassId() {
        return 6;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeBoolean("r", this.retain);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeInt(this.valueSet.size());
        for (Data value : this.valueSet) {
            value.writeData(out);
        }
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.retain = reader.readBoolean("r");
        ObjectDataInput in = reader.getRawDataInput();
        int size = in.readInt();
        this.valueSet = new HashSet<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data value = new Data();
            value.readData(in);
            this.valueSet.add(value);
        }
    }

    @Override
    public String getRequiredAction() {
        return "remove";
    }

    @Override
    public String getMethodName() {
        if (this.retain) {
            return "retainAll";
        }
        return "removeAll";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.valueSet};
    }
}

