/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.CacheClearResponse;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.operation.CacheClearBackupOperation;
import com.hazelcast.cache.impl.operation.PartitionWideCacheOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import java.util.HashSet;
import java.util.Set;
import javax.cache.CacheException;

public class CacheClearOperation
extends PartitionWideCacheOperation
implements BackupAwareOperation {
    private boolean isRemoveAll;
    private Set<Data> keys;
    private int completionId;
    private boolean shouldBackup;
    private transient Set<Data> backupKeys = new HashSet<Data>();
    private transient ICacheRecordStore cache;

    public CacheClearOperation() {
    }

    public CacheClearOperation(String name, Set<Data> keys, boolean isRemoveAll, int completionId) {
        super(name);
        this.keys = keys;
        this.isRemoveAll = isRemoveAll;
        this.completionId = completionId;
    }

    @Override
    public void run() {
        CacheService service = (CacheService)this.getService();
        InternalPartitionService partitionService = this.getNodeEngine().getPartitionService();
        this.cache = service.getCache(this.name, this.getPartitionId());
        if (this.cache != null) {
            HashSet<Data> filteredKeys = new HashSet<Data>();
            if (this.keys != null) {
                for (Data k : this.keys) {
                    if (partitionService.getPartitionId(k) != this.getPartitionId()) continue;
                    filteredKeys.add(k);
                }
            }
            try {
                if (this.keys == null || !filteredKeys.isEmpty()) {
                    this.cache.clear(filteredKeys, this.isRemoveAll);
                    this.response = new CacheClearResponse(Boolean.TRUE);
                    int orderKey = this.keys != null ? this.keys.hashCode() : 1;
                    this.cache.publishCompletedEvent(this.name, this.completionId, new Data(), orderKey);
                }
            }
            catch (CacheException e) {
                this.response = new CacheClearResponse((Object)e);
            }
            boolean bl = this.shouldBackup = !filteredKeys.isEmpty();
            if (this.shouldBackup) {
                for (Data key : filteredKeys) {
                    this.backupKeys.add(key);
                }
            }
        }
    }

    @Override
    public int getId() {
        return 15;
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup;
    }

    @Override
    public final int getSyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getBackupCount() : 0;
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getAsyncBackupCount() : 0;
    }

    @Override
    public Operation getBackupOperation() {
        return new CacheClearBackupOperation(this.name, this.backupKeys);
    }
}

