/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.client.AbstractCacheRequest;
import com.hazelcast.cache.impl.operation.CacheGetOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import javax.cache.expiry.ExpiryPolicy;

public class CacheGetRequest
extends AbstractCacheRequest {
    protected Data key;
    protected ExpiryPolicy expiryPolicy;

    public CacheGetRequest() {
    }

    public CacheGetRequest(String name, Data key) {
        super(name);
        this.key = key;
    }

    public CacheGetRequest(String name, Data key, ExpiryPolicy expiryPolicy) {
        super(name);
        this.key = key;
        this.expiryPolicy = expiryPolicy;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    protected Object getKey() {
        return this.key;
    }

    @Override
    protected Operation prepareOperation() {
        return new CacheGetOperation(this.name, this.key, this.expiryPolicy);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
        out.writeObject(this.expiryPolicy);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
        this.expiryPolicy = (ExpiryPolicy)in.readObject();
    }
}

