/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.operation.CacheDestroyOperation;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.util.executor.CompletableFutureTask;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.CacheException;
import javax.cache.configuration.Factory;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CompletionListener;

abstract class AbstractCacheProxyBase<K, V> {
    static final int TIMEOUT = 10;
    protected final CacheConfig<K, V> cacheConfig;
    protected final String name;
    protected final String nameWithPrefix;
    protected final CacheService cacheService;
    protected final SerializationService serializationService;
    private final NodeEngine nodeEngine;
    private final CopyOnWriteArrayList<Future> loadAllTasks = new CopyOnWriteArrayList();
    private final CacheLoader<K, V> cacheLoader;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicBoolean isDestroyed = new AtomicBoolean(false);

    protected AbstractCacheProxyBase(CacheConfig cacheConfig, NodeEngine nodeEngine, CacheService cacheService) {
        this.name = cacheConfig.getName();
        this.nameWithPrefix = cacheConfig.getNameWithPrefix();
        this.cacheConfig = cacheConfig;
        this.nodeEngine = nodeEngine;
        this.cacheService = cacheService;
        this.serializationService = this.nodeEngine.getSerializationService();
        if (cacheConfig.getCacheLoaderFactory() != null) {
            Factory cacheLoaderFactory = cacheConfig.getCacheLoaderFactory();
            this.cacheLoader = (CacheLoader)cacheLoaderFactory.create();
        } else {
            this.cacheLoader = null;
        }
    }

    protected void ensureOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Cache operations can not be performed. The cache closed");
        }
    }

    public void close() {
        if (!this.isClosed.compareAndSet(false, true)) {
            return;
        }
        for (Future f : this.loadAllTasks) {
            try {
                f.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
        this.loadAllTasks.clear();
        this.closeCacheLoader();
        this.closeListeners();
    }

    public void destroy() {
        this.close();
        if (!this.isDestroyed.compareAndSet(false, true)) {
            return;
        }
        this.isClosed.set(true);
        CacheDestroyOperation op = new CacheDestroyOperation(this.getDistributedObjectName());
        int partitionId = this.getNodeEngine().getPartitionService().getPartitionId(this.getDistributedObjectName());
        InternalCompletableFuture f = this.getNodeEngine().getOperationService().invokeOnPartition("hz:impl:cacheService", op, partitionId);
        f.getSafely();
        this.cacheService.destroyCache(this.getDistributedObjectName(), true, null);
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    protected abstract void closeListeners();

    protected String getDistributedObjectName() {
        return this.nameWithPrefix;
    }

    protected String getServiceName() {
        return "hz:impl:cacheService";
    }

    protected CacheService getService() {
        return this.cacheService;
    }

    protected NodeEngine getNodeEngine() {
        if (this.nodeEngine == null || !this.nodeEngine.isActive()) {
            throw new HazelcastInstanceNotActiveException();
        }
        return this.nodeEngine;
    }

    protected void validateCacheLoader(CompletionListener completionListener) {
        if (this.cacheLoader == null && completionListener != null) {
            completionListener.onCompletion();
        }
    }

    protected void closeCacheLoader() {
        if (this.cacheLoader instanceof Closeable) {
            IOUtil.closeResource((Closeable)this.cacheLoader);
        }
    }

    protected void submitLoadAllTask(OperationFactory operationFactory, CompletionListener completionListener) {
        LoadAllTask loadAllTask = new LoadAllTask(operationFactory, completionListener);
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        final CompletableFutureTask future = (CompletableFutureTask)executionService.submit("loadAll-" + this.nameWithPrefix, loadAllTask);
        this.loadAllTasks.add(future);
        future.andThen(new ExecutionCallback(){

            public void onResponse(Object response) {
                AbstractCacheProxyBase.this.loadAllTasks.remove(future);
            }

            @Override
            public void onFailure(Throwable t) {
                AbstractCacheProxyBase.this.loadAllTasks.remove(future);
            }
        });
    }

    private final class LoadAllTask
    implements Runnable {
        private final OperationFactory operationFactory;
        private final CompletionListener completionListener;

        private LoadAllTask(OperationFactory operationFactory, CompletionListener completionListener) {
            this.operationFactory = operationFactory;
            this.completionListener = completionListener;
        }

        @Override
        public void run() {
            block3: {
                try {
                    Map<Integer, Object> results = AbstractCacheProxyBase.this.getNodeEngine().getOperationService().invokeOnAllPartitions(AbstractCacheProxyBase.this.getServiceName(), this.operationFactory);
                    CacheProxyUtil.validateResults(results);
                    if (this.completionListener != null) {
                        this.completionListener.onCompletion();
                    }
                }
                catch (Exception e) {
                    if (this.completionListener == null) break block3;
                    this.completionListener.onException(e);
                }
            }
        }
    }
}

