/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ascii;

import com.hazelcast.ascii.AbstractTextCommand;
import com.hazelcast.ascii.NoOpCommandProcessor;
import com.hazelcast.ascii.TextCommand;
import com.hazelcast.ascii.TextCommandConstants;
import com.hazelcast.ascii.TextCommandProcessor;
import com.hazelcast.ascii.TextCommandService;
import com.hazelcast.ascii.memcache.DeleteCommandProcessor;
import com.hazelcast.ascii.memcache.ErrorCommandProcessor;
import com.hazelcast.ascii.memcache.GetCommandProcessor;
import com.hazelcast.ascii.memcache.IncrementCommandProcessor;
import com.hazelcast.ascii.memcache.SetCommandProcessor;
import com.hazelcast.ascii.memcache.SimpleCommandProcessor;
import com.hazelcast.ascii.memcache.Stats;
import com.hazelcast.ascii.memcache.StatsCommandProcessor;
import com.hazelcast.ascii.memcache.TouchCommandProcessor;
import com.hazelcast.ascii.memcache.VersionCommandProcessor;
import com.hazelcast.ascii.rest.HttpDeleteCommandProcessor;
import com.hazelcast.ascii.rest.HttpGetCommandProcessor;
import com.hazelcast.ascii.rest.HttpPostCommandProcessor;
import com.hazelcast.ascii.rest.RestValue;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ascii.SocketTextWriter;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TextCommandServiceImpl
implements TextCommandService {
    private static final int TEXT_COMMAND_PROCESSOR_SIZE = 100;
    private static final int MILLIS_TO_SECONDS = 1000;
    private static final long WAIT_TIME = 1000L;
    private final Node node;
    private final TextCommandProcessor[] textCommandProcessors = new TextCommandProcessor[100];
    private final HazelcastInstance hazelcast;
    private final AtomicLong sets = new AtomicLong();
    private final AtomicLong touches = new AtomicLong();
    private final AtomicLong getHits = new AtomicLong();
    private final AtomicLong getMisses = new AtomicLong();
    private final AtomicLong deleteMisses = new AtomicLong();
    private final AtomicLong deleteHits = new AtomicLong();
    private final AtomicLong incrementHits = new AtomicLong();
    private final AtomicLong incrementMisses = new AtomicLong();
    private final AtomicLong decrementHits = new AtomicLong();
    private final AtomicLong decrementMisses = new AtomicLong();
    private final long startTime = Clock.currentTimeMillis();
    private final ILogger logger;
    private volatile ResponseThreadRunnable responseThreadRunnable;
    private volatile boolean running = true;

    public TextCommandServiceImpl(Node node) {
        this.node = node;
        this.hazelcast = node.hazelcastInstance;
        this.logger = node.getLogger(this.getClass().getName());
        this.textCommandProcessors[TextCommandConstants.TextCommandType.GET.getValue()] = new GetCommandProcessor(this, true);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.PARTIAL_GET.getValue()] = new GetCommandProcessor(this, false);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.SET.getValue()] = new SetCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.APPEND.getValue()] = new SetCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.PREPEND.getValue()] = new SetCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.ADD.getValue()] = new SetCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.REPLACE.getValue()] = new SetCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.GET_END.getValue()] = new NoOpCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.DELETE.getValue()] = new DeleteCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.QUIT.getValue()] = new SimpleCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.STATS.getValue()] = new StatsCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.UNKNOWN.getValue()] = new ErrorCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.VERSION.getValue()] = new VersionCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.TOUCH.getValue()] = new TouchCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.INCREMENT.getValue()] = new IncrementCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.DECREMENT.getValue()] = new IncrementCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.ERROR_CLIENT.getValue()] = new ErrorCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.ERROR_SERVER.getValue()] = new ErrorCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.HTTP_GET.getValue()] = new HttpGetCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.HTTP_POST.getValue()] = new HttpPostCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.HTTP_PUT.getValue()] = new HttpPostCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.HTTP_DELETE.getValue()] = new HttpDeleteCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.NO_OP.getValue()] = new NoOpCommandProcessor(this);
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public byte[] toByteArray(Object value) {
        Data data = this.node.getSerializationService().toData(value);
        return data.getBuffer();
    }

    @Override
    public Stats getStats() {
        Stats stats = new Stats();
        stats.setUptime((int)((Clock.currentTimeMillis() - this.startTime) / 1000L));
        stats.setCmdGet(this.getMisses.get() + this.getHits.get());
        stats.setCmdSet(this.sets.get());
        stats.setCmdTouch(this.touches.get());
        stats.setGetHits(this.getHits.get());
        stats.setGetMisses(this.getMisses.get());
        stats.setDeleteHits(this.deleteHits.get());
        stats.setDeleteMisses(this.deleteMisses.get());
        stats.setIncrHits(this.incrementHits.get());
        stats.setIncrMisses(this.incrementMisses.get());
        stats.setDecrHits(this.decrementHits.get());
        stats.setDecrMisses(this.decrementMisses.get());
        stats.setCurrConnections(this.node.connectionManager.getCurrentClientConnections());
        stats.setTotalConnections(this.node.connectionManager.getAllTextConnections());
        return stats;
    }

    @Override
    public long incrementDeleteHitCount(int inc) {
        return this.deleteHits.addAndGet(inc);
    }

    @Override
    public long incrementDeleteMissCount() {
        return this.deleteMisses.incrementAndGet();
    }

    @Override
    public long incrementGetHitCount() {
        return this.getHits.incrementAndGet();
    }

    @Override
    public long incrementGetMissCount() {
        return this.getMisses.incrementAndGet();
    }

    @Override
    public long incrementSetCount() {
        return this.sets.incrementAndGet();
    }

    @Override
    public long incrementIncHitCount() {
        return this.incrementHits.incrementAndGet();
    }

    @Override
    public long incrementIncMissCount() {
        return this.incrementMisses.incrementAndGet();
    }

    @Override
    public long incrementDecrHitCount() {
        return this.decrementHits.incrementAndGet();
    }

    @Override
    public long incrementDecrMissCount() {
        return this.decrementMisses.incrementAndGet();
    }

    @Override
    public long incrementTouchCount() {
        return this.touches.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(TextCommand command) {
        if (this.responseThreadRunnable == null) {
            TextCommandServiceImpl textCommandServiceImpl = this;
            synchronized (textCommandServiceImpl) {
                if (this.responseThreadRunnable == null) {
                    this.responseThreadRunnable = new ResponseThreadRunnable();
                    String threadNamePrefix = this.node.getThreadNamePrefix("ascii.service.response");
                    Thread thread = new Thread(this.node.threadGroup, this.responseThreadRunnable, threadNamePrefix);
                    thread.start();
                }
            }
        }
        this.node.nodeEngine.getExecutionService().execute("hz:text", new CommandExecutor(command));
    }

    @Override
    public Object get(String mapName, String key) {
        return this.hazelcast.getMap(mapName).get(key);
    }

    @Override
    public int getAdjustedTTLSeconds(int ttl) {
        if (ttl <= TextCommandConstants.getMonthSeconds()) {
            return ttl;
        }
        return ttl - (int)TimeUnit.MILLISECONDS.toSeconds(Clock.currentTimeMillis());
    }

    @Override
    public byte[] getByteArray(String mapName, String key) {
        Object value = this.hazelcast.getMap(mapName).get(key);
        byte[] result = null;
        if (value != null) {
            if (value instanceof RestValue) {
                RestValue restValue = (RestValue)value;
                result = restValue.getValue();
            } else {
                result = value instanceof byte[] ? (byte[])value : this.toByteArray(value);
            }
        }
        return result;
    }

    @Override
    public Object put(String mapName, String key, Object value) {
        return this.hazelcast.getMap(mapName).put(key, value);
    }

    @Override
    public Object put(String mapName, String key, Object value, int ttlSeconds) {
        return this.hazelcast.getMap(mapName).put(key, value, ttlSeconds, TimeUnit.SECONDS);
    }

    @Override
    public Object putIfAbsent(String mapName, String key, Object value, int ttlSeconds) {
        return this.hazelcast.getMap(mapName).putIfAbsent(key, value, ttlSeconds, TimeUnit.SECONDS);
    }

    @Override
    public Object replace(String mapName, String key, Object value) {
        return this.hazelcast.getMap(mapName).replace(key, value);
    }

    @Override
    public void lock(String mapName, String key) throws InterruptedException {
        if (!this.hazelcast.getMap(mapName).tryLock(key, 1L, TimeUnit.MINUTES)) {
            throw new RuntimeException("Memcache client could not get the lock for map:" + mapName + " key:" + key + " in 1 minute");
        }
    }

    @Override
    public void unlock(String mapName, String key) {
        this.hazelcast.getMap(mapName).unlock(key);
    }

    @Override
    public void deleteAll(String mapName) {
        IMap map = this.hazelcast.getMap(mapName);
        map.clear();
    }

    @Override
    public Object delete(String mapName, String key) {
        return this.hazelcast.getMap(mapName).remove(key);
    }

    @Override
    public boolean offer(String queueName, Object value) {
        return this.hazelcast.getQueue(queueName).offer(value);
    }

    @Override
    public Object poll(String queueName, int seconds) {
        try {
            return this.hazelcast.getQueue(queueName).poll(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public Object poll(String queueName) {
        return this.hazelcast.getQueue(queueName).poll();
    }

    @Override
    public int size(String queueName) {
        return this.hazelcast.getQueue(queueName).size();
    }

    @Override
    public void sendResponse(TextCommand textCommand) {
        if (!textCommand.shouldReply() || textCommand.getRequestId() == -1L) {
            throw new RuntimeException("Shouldn't reply " + textCommand);
        }
        this.responseThreadRunnable.sendResponse(textCommand);
    }

    public void stop() {
        ResponseThreadRunnable rtr = this.responseThreadRunnable;
        if (rtr != null) {
            rtr.stop();
        }
    }

    private class ResponseThreadRunnable
    implements Runnable {
        private final BlockingQueue<TextCommand> blockingQueue = new ArrayBlockingQueue<TextCommand>(200);
        private final Object stopObject = new Object();

        private ResponseThreadRunnable() {
        }

        @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
        public void sendResponse(TextCommand textCommand) {
            this.blockingQueue.offer(textCommand);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (TextCommandServiceImpl.this.running) {
                try {
                    TextCommand textCommand = this.blockingQueue.take();
                    if (TextCommandConstants.TextCommandType.STOP == textCommand.getType()) {
                        Object object = this.stopObject;
                        synchronized (object) {
                            this.stopObject.notify();
                            continue;
                        }
                    }
                    SocketTextWriter socketTextWriter = textCommand.getSocketTextWriter();
                    socketTextWriter.enqueue(textCommand);
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (OutOfMemoryError e) {
                    OutOfMemoryErrorDispatcher.onOutOfMemory(e);
                    throw e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
        void stop() {
            TextCommandServiceImpl.this.running = false;
            Object object = this.stopObject;
            synchronized (object) {
                try {
                    this.blockingQueue.offer(new AbstractTextCommand(TextCommandConstants.TextCommandType.STOP){

                        @Override
                        public boolean readFrom(ByteBuffer cb) {
                            return true;
                        }

                        @Override
                        public boolean writeTo(ByteBuffer bb) {
                            return true;
                        }
                    });
                    this.stopObject.wait(1000L);
                }
                catch (Exception ignored) {
                    EmptyStatement.ignore(ignored);
                }
            }
        }
    }

    class CommandExecutor
    implements Runnable {
        final TextCommand command;

        CommandExecutor(TextCommand command) {
            this.command = command;
        }

        @Override
        public void run() {
            try {
                TextCommandConstants.TextCommandType type = this.command.getType();
                TextCommandProcessor textCommandProcessor = TextCommandServiceImpl.this.textCommandProcessors[type.getValue()];
                textCommandProcessor.handle(this.command);
            }
            catch (Throwable e) {
                TextCommandServiceImpl.this.logger.warning(e);
            }
        }
    }
}

