/*
 * Decompiled with CFR 0.152.
 */
package com.rayo.core.verb;

import com.rayo.core.validation.ValidCPA;
import com.rayo.core.validation.ValidChoices;
import com.rayo.core.verb.BaseVerb;
import com.rayo.core.verb.Choices;
import com.rayo.core.verb.CpaData;
import com.rayo.core.verb.InputMode;
import java.util.List;
import javax.validation.constraints.AssertTrue;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.joda.time.Duration;

@ValidChoices
public class Input
extends BaseVerb {
    private List<Choices> grammars;
    private String recognizer;
    private Duration initialTimeout;
    private Duration interDigitTimeout;
    private Float minConfidence = Float.valueOf(0.3f);
    private Float sensitivity;
    private Character terminator;
    private InputMode mode = InputMode.ANY;
    @ValidCPA
    private CpaData cpaData;
    private Duration maxSilence;

    public Duration getInitialTimeout() {
        return this.initialTimeout;
    }

    public void setInitialTimeout(Duration initialTimeout) {
        this.initialTimeout = initialTimeout;
    }

    public Duration getInterDigitTimeout() {
        return this.interDigitTimeout;
    }

    public void setInterDigitTimeout(Duration interSigTimeout) {
        this.interDigitTimeout = interSigTimeout;
    }

    public Float getMinConfidence() {
        return this.minConfidence;
    }

    public void setMinConfidence(Float confidence) {
        this.minConfidence = confidence;
    }

    public Float getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(Float sensitivity) {
        this.sensitivity = sensitivity;
    }

    public String getRecognizer() {
        return this.recognizer;
    }

    public void setRecognizer(String recognizer) {
        this.recognizer = recognizer;
    }

    public Character getTerminator() {
        return this.terminator;
    }

    public void setTerminator(Character terminator) {
        this.terminator = terminator;
    }

    public InputMode getMode() {
        return this.mode;
    }

    public void setMode(InputMode inputMode) {
        this.mode = inputMode;
    }

    public List<Choices> getGrammars() {
        return this.grammars;
    }

    public void setGrammars(List<Choices> grammars) {
        this.grammars = grammars;
    }

    @AssertTrue(message="Confidence must be a value between 0 and 1.")
    public boolean isMinConfidenceWithinRange() {
        return this.minConfidence.floatValue() >= 0.0f && this.minConfidence.floatValue() <= 1.0f;
    }

    @AssertTrue(message="Sensitivity must be a value between 0 and 1.")
    public boolean isSensitivityWithinRange() {
        return this.sensitivity == null || this.sensitivity.floatValue() >= 0.0f && this.sensitivity.floatValue() <= 1.0f;
    }

    @AssertTrue(message="Max Silence needs to be greater or equal to 0.")
    public boolean isMaxSilenceWithinRange() {
        return this.maxSilence == null || this.maxSilence.getMillis() >= 0L;
    }

    public Duration getMaxSilence() {
        return this.maxSilence;
    }

    public void setMaxSilence(Duration maxSilence) {
        this.maxSilence = maxSilence;
    }

    public CpaData getCpaData() {
        return this.cpaData;
    }

    public void setCpaData(CpaData cpaData) {
        this.cpaData = cpaData;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("callId", (Object)this.getCallId()).append("verbId", (Object)this.getVerbId()).append("minConfidence", (Object)this.getMinConfidence()).append("initialTimeout", (Object)this.getInitialTimeout()).append("mode", (Object)this.getMode()).append("integerSigTimeout", (Object)this.getInterDigitTimeout()).append("recognizer", (Object)this.getRecognizer()).append("sensitivity", (Object)this.getSensitivity()).append("terminator", (Object)this.getTerminator()).append("maxSilence", (Object)this.getMaxSilence()).append("grammars", this.grammars).append("cpaData", (Object)this.getCpaData()).toString();
    }
}

