/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.transform;

import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.util.BadFormatException;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPPacketParserEx;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.Transformer;
import org.jitsi.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTCPTransformEngine
extends SinglePacketTransformer
implements TransformEngine,
Transformer<RTCPCompoundPacket> {
    private static final Logger logger = Logger.getLogger(RTCPTransformEngine.class);
    private Transformer<RTCPCompoundPacket>[] chain;
    private final RTCPPacketParserEx parser = new RTCPPacketParserEx();

    public RTCPTransformEngine(Transformer<RTCPCompoundPacket>[] chain) {
        this.chain = chain;
    }

    public RTCPCompoundPacket transform(RTCPCompoundPacket rtcpCompoundPacket) {
        return rtcpCompoundPacket;
    }

    public RTCPCompoundPacket reverseTransform(RTCPCompoundPacket inPacket) {
        if (this.chain != null) {
            for (Transformer<RTCPCompoundPacket> transformer : this.chain) {
                if (transformer == null) continue;
                inPacket = (RTCPCompoundPacket)transformer.reverseTransform((Object)inPacket);
            }
        }
        return inPacket;
    }

    public void close() {
    }

    public PacketTransformer getRTPTransformer() {
        return null;
    }

    public PacketTransformer getRTCPTransformer() {
        return this;
    }

    public RawPacket transform(RawPacket packet) {
        return packet;
    }

    public RawPacket reverseTransform(RawPacket pkt) {
        RTCPCompoundPacket inRTCPPacket;
        try {
            inRTCPPacket = (RTCPCompoundPacket)this.parser.parse(pkt.getBuffer(), pkt.getOffset(), pkt.getLength());
        }
        catch (BadFormatException e) {
            logger.error((Object)"Could not parse RTCP packet.", (Throwable)e);
            return pkt;
        }
        RTCPCompoundPacket outRTCPPacket = this.reverseTransform(inRTCPPacket);
        if (outRTCPPacket == null || outRTCPPacket.packets == null || outRTCPPacket.packets.length == 0) {
            return null;
        }
        int len = outRTCPPacket.calcLength();
        outRTCPPacket.assemble(len, false);
        pkt.setBuffer(outRTCPPacket.data);
        pkt.setLength(outRTCPPacket.data.length);
        pkt.setOffset(0);
        return pkt;
    }
}

