/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network.event;

import org.openymsg.network.chatroom.YahooChatLobby;
import org.openymsg.network.chatroom.YahooChatUser;
import org.openymsg.network.event.SessionEvent;

public class SessionChatEvent
extends SessionEvent {
    protected YahooChatUser[] users;
    protected YahooChatLobby lobby;
    protected boolean emote;
    protected String captchaMsg;
    protected String captchaURL;

    public SessionChatEvent(Object source, int size, YahooChatLobby ycl) {
        super(source);
        this.users = new YahooChatUser[size];
        this.lobby = ycl;
    }

    public SessionChatEvent(Object source, YahooChatUser ycu, String message, String emote, YahooChatLobby ycl) {
        this(source, 1, ycl);
        this.setChatUser(0, ycu);
        this.message = message;
        this.emote = emote != null && emote.equals("2");
    }

    public SessionChatEvent(Object o, String capM, String capU, YahooChatLobby ycl) {
        super(o);
        this.captchaMsg = capM;
        this.captchaURL = capU;
        this.lobby = ycl;
    }

    public void setChatUser(int i, YahooChatUser ycu) {
        this.users[i] = ycu;
    }

    public YahooChatUser getChatUser() {
        return this.users[0];
    }

    public YahooChatUser[] getChatUsers() {
        return this.users;
    }

    public YahooChatLobby getLobby() {
        return this.lobby;
    }

    public String getFrom() {
        return this.users[0].getId();
    }

    public boolean isEmote() {
        return this.emote;
    }

    public String getCaptchaMessage() {
        return this.captchaMsg;
    }

    public String getCaptchaURL() {
        return this.captchaURL;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(" size:").append(this.users.length).append(" chatuser:").append(this.users[0].getId()).append(" lobby:").append(this.lobby.getNetworkName());
        return sb.toString();
    }
}

