/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

public class PacketCollector {
    private PacketFilter packetFilter;
    private ArrayBlockingQueue<Packet> resultQueue;
    private Connection connection;
    private boolean cancelled = false;

    protected PacketCollector(Connection conection, PacketFilter packetFilter) {
        this(conection, packetFilter, SmackConfiguration.getPacketCollectorSize());
    }

    protected PacketCollector(Connection conection, PacketFilter packetFilter, int maxSize) {
        this.connection = conection;
        this.packetFilter = packetFilter;
        this.resultQueue = new ArrayBlockingQueue(maxSize);
    }

    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.connection.removePacketCollector(this);
        }
    }

    public PacketFilter getPacketFilter() {
        return this.packetFilter;
    }

    public Packet pollResult() {
        return this.resultQueue.poll();
    }

    public Packet nextResult() {
        try {
            return this.resultQueue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Packet nextResult(long timeout) {
        try {
            return this.resultQueue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        if (this.packetFilter == null || this.packetFilter.accept(packet)) {
            while (!this.resultQueue.offer(packet)) {
                this.resultQueue.poll();
            }
        }
    }
}

