/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.client;

import com.hazelcast.collection.client.CollectionRequest;
import com.hazelcast.collection.list.ListIndexOfOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class ListIndexOfRequest
extends CollectionRequest {
    Data value;
    boolean last;

    public ListIndexOfRequest() {
    }

    public ListIndexOfRequest(String name, Data value, boolean last) {
        super(name);
        this.value = value;
        this.last = last;
    }

    @Override
    protected Operation prepareOperation() {
        return new ListIndexOfOperation(this.name, this.last, this.value);
    }

    @Override
    public int getClassId() {
        return 15;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeBoolean("l", this.last);
        writer.getRawDataOutput().writeData(this.value);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.last = reader.readBoolean("l");
        this.value = reader.getRawDataInput().readData();
    }

    @Override
    public String getRequiredAction() {
        return "read";
    }

    @Override
    public String getMethodName() {
        if (this.last) {
            return "lastIndexOf";
        }
        return "indexOf";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.value};
    }
}

