/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import org.bitlet.weupnp.GatewayDevice;
import org.ice4j.TransportAddress;
import org.ice4j.ice.CandidateExtendedType;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.Component;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.socket.IceSocketWrapper;

public class UPNPCandidate
extends LocalCandidate {
    private GatewayDevice device = null;

    public UPNPCandidate(TransportAddress transportAddress, LocalCandidate base, Component parentComponent, GatewayDevice device) {
        super(transportAddress, parentComponent, CandidateType.SERVER_REFLEXIVE_CANDIDATE, CandidateExtendedType.UPNP_CANDIDATE, base);
        this.setBase(base);
        this.device = device;
        this.setStunServerAddress(transportAddress);
    }

    protected void free() {
        try {
            this.device.deletePortMapping(this.getTransportAddress().getPort(), "UDP");
        }
        catch (Exception e) {
            // empty catch block
        }
        IceSocketWrapper socket = this.getIceSocketWrapper();
        if (socket != null) {
            socket.close();
        }
        this.device = null;
    }

    public IceSocketWrapper getIceSocketWrapper() {
        return ((LocalCandidate)this.getBase()).getIceSocketWrapper();
    }
}

