/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.mn.communicator.ILocalStatus;
import pl.mn.communicator.LocalStatus;
import pl.mn.communicator.StatusType;

public final class LoginContext {
    private static final Log LOGGER = LogFactory.getLog((Class)LoginContext.class);
    private int m_uin = -1;
    private String m_password = null;
    private ILocalStatus m_localStatus = new LocalStatus(StatusType.ONLINE);
    private Collection m_monitoredUsers = new ArrayList();
    private byte m_imageSize = (byte)64;
    private byte[] m_localIP = null;
    private int m_localPort = -1;
    private byte[] m_externalIP = null;
    private int m_externalPort = -1;

    public LoginContext(int uin, String password) {
        if (uin < 0) {
            throw new IllegalArgumentException("uin cannot be less than 0");
        }
        if (password == null) {
            throw new NullPointerException("password cannot be null");
        }
        this.m_uin = uin;
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }

    public int getUin() {
        return this.m_uin;
    }

    public void setPassword(String password) {
        if (password == null) {
            throw new NullPointerException("password cannot be null");
        }
        this.m_password = password;
    }

    public void setUin(int uin) {
        if (uin < 0) {
            throw new IllegalArgumentException("uin must be a positive number");
        }
        this.m_uin = uin;
    }

    public void setStatus(ILocalStatus localStatus) {
        if (localStatus == null) {
            throw new NullPointerException("localStatus cannot be null");
        }
        this.m_localStatus = localStatus;
    }

    public ILocalStatus getStatus() {
        return this.m_localStatus;
    }

    public void setImageSize(byte imageSize) {
        if (imageSize < 0) {
            throw new IllegalArgumentException("imageSize cannot be less than 0");
        }
        this.m_imageSize = imageSize;
    }

    public byte getImageSize() {
        return this.m_imageSize;
    }

    public byte[] getExternalIP() {
        return this.m_externalIP;
    }

    public void setExternalIP(byte[] externalIP) {
        if (externalIP == null) {
            throw new NullPointerException("externalIP cannot be null");
        }
        if (externalIP.length == 4) {
            throw new IllegalArgumentException("Incorrect address.");
        }
        this.m_externalIP = externalIP;
    }

    public void setExternalPort(int externalPort) {
        if (externalPort < 0) {
            throw new IllegalArgumentException("externalPort cannot be less than 0");
        }
        this.m_externalPort = externalPort;
    }

    public int getExternalPort() {
        return this.m_externalPort;
    }

    public byte[] getLocalIP() {
        return this.m_localIP;
    }

    public void setLocalIP(byte[] localIP) {
        if (localIP == null) {
            throw new NullPointerException("localIP cannot be null");
        }
        this.m_localIP = localIP;
        if (localIP.length == 4) {
            throw new IllegalArgumentException("Incorrect address.");
        }
    }

    public void setLocalPort(int localPort) {
        if (localPort < 0) {
            throw new IllegalArgumentException("localPort cannot be less than 0");
        }
        this.m_localPort = localPort;
    }

    public int getLocalPort() {
        return this.m_localPort;
    }

    public Collection getMonitoredUsers() {
        return this.m_monitoredUsers;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("LoginContext[");
        buffer.append("uin=" + this.m_uin);
        buffer.append(",password=xxx(masking)]");
        return buffer.toString();
    }
}

