/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaType;

public class CallEvent
extends EventObject {
    public static final int CALL_ENDED = 3;
    public static final int CALL_INITIATED = 1;
    public static final int CALL_RECEIVED = 2;
    private static final long serialVersionUID = 0L;
    private final int eventID;
    private final Map<MediaType, MediaDirection> mediaDirections;
    private final CallConference conference;

    public CallEvent(Call call, int eventID) {
        this(call, eventID, null);
    }

    public CallEvent(Call call, int eventID, Map<MediaType, MediaDirection> mediaDirections) {
        super(call);
        this.eventID = eventID;
        HashMap<MediaType, MediaDirection> thisMediaDirections = new HashMap<MediaType, MediaDirection>();
        if (mediaDirections != null) {
            thisMediaDirections.putAll(mediaDirections);
        }
        this.mediaDirections = Collections.unmodifiableMap(thisMediaDirections);
        this.conference = call.getConference();
    }

    public int getEventID() {
        return this.eventID;
    }

    public Map<MediaType, MediaDirection> getMediaDirections() {
        return this.mediaDirections;
    }

    public List<MediaType> getMediaTypes() {
        return new ArrayList<MediaType>(this.mediaDirections.keySet());
    }

    public Call getSourceCall() {
        return (Call)this.getSource();
    }

    public CallConference getCallConference() {
        return this.conference;
    }

    public boolean isVideoCall() {
        MediaDirection direction = this.mediaDirections.get(MediaType.VIDEO);
        return direction == null ? false : direction == MediaDirection.SENDRECV;
    }

    @Override
    public String toString() {
        return "CallEvent:[ id=" + this.getEventID() + " Call=" + this.getSourceCall() + "]";
    }
}

