/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.ComponentImpl;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.osgi.framework.BundleContext;

public class Videobridge {
    private static final Logger logger = Logger.getLogger(Videobridge.class);
    static final Random RANDOM = new Random();
    private static String defaultTransportManager;
    private final ComponentImpl component;
    private final Map<String, Conference> conferences = new HashMap<String, Conference>();

    private static void logd(String s) {
        logger.info((Object)s);
    }

    public Videobridge(ComponentImpl component) {
        if (component == null) {
            throw new NullPointerException("component");
        }
        this.component = component;
        this.logConfigurationServiceProperties();
        new ExpireThread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conference createConference(String focus) {
        Conference conference = null;
        do {
            String id = this.generateConferenceID();
            Map<String, Conference> map = this.conferences;
            synchronized (map) {
                if (!this.conferences.containsKey(id)) {
                    conference = new Conference(this, id, focus);
                    this.conferences.put(id, conference);
                }
            }
        } while (conference == null);
        Videobridge.logd("Created conference " + conference.getID() + ". The total number of conferences is now " + this.getConferenceCount() + ", channels " + this.getChannelCount() + ".");
        return conference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireConference(Conference conference) {
        boolean expireConference;
        String id = conference.getID();
        Map<String, Conference> map = this.conferences;
        synchronized (map) {
            if (conference.equals(this.conferences.get(id))) {
                this.conferences.remove(id);
                expireConference = true;
            } else {
                expireConference = false;
            }
        }
        if (expireConference) {
            conference.expire();
        }
    }

    private String generateConferenceID() {
        return Long.toHexString(System.currentTimeMillis() + RANDOM.nextLong());
    }

    int getChannelCount() {
        int channelCount = 0;
        for (Conference conference : this.getConferences()) {
            for (Content contents : conference.getContents()) {
                channelCount += contents.getChannelCount();
            }
        }
        return channelCount;
    }

    public ComponentImpl getComponent() {
        return this.component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conference getConference(String id, String focus) {
        Conference conference;
        Map<String, Conference> map = this.conferences;
        synchronized (map) {
            conference = this.conferences.get(id);
        }
        if (conference != null) {
            if (conference.getFocus().equals(focus)) {
                conference.touch();
            } else {
                conference = null;
            }
        }
        return conference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConferenceCount() {
        Map<String, Conference> map = this.conferences;
        synchronized (map) {
            return this.conferences.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conference[] getConferences() {
        Map<String, Conference> map = this.conferences;
        synchronized (map) {
            Collection<Conference> values = this.conferences.values();
            return values.toArray(new Conference[values.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultTransportManager() {
        Class<Videobridge> clazz = Videobridge.class;
        synchronized (Videobridge.class) {
            if (defaultTransportManager == null) {
                ConfigurationService cfg;
                BundleContext bundleContext = this.getComponent().getBundleContext();
                if (bundleContext != null && (cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class)) != null) {
                    defaultTransportManager = cfg.getString(Videobridge.class.getName() + ".defaultTransportManager");
                }
                if (!"urn:xmpp:jingle:transports:ice-udp:1".equals(defaultTransportManager) && !"urn:xmpp:jingle:transports:raw-udp:1".equals(defaultTransportManager)) {
                    defaultTransportManager = "urn:xmpp:jingle:transports:ice-udp:1";
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultTransportManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logConfigurationServiceProperties() {
        if (!logger.isInfoEnabled()) {
            return;
        }
        boolean interrupted = false;
        try {
            try {
                ConfigurationService cfg;
                BundleContext bundleContext = this.getComponent().getBundleContext();
                if (bundleContext != null && (cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class)) != null) {
                    for (String p : cfg.getAllPropertyNames()) {
                        Object v = cfg.getProperty(p);
                        if (v == null) continue;
                        logger.info((Object)(p + "=" + v));
                    }
                }
                Object var8_8 = null;
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    interrupted = true;
                } else if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                Object var8_9 = null;
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
    }

    private static class ExpireThread
    extends Thread {
        private final WeakReference<Videobridge> videobridge;

        public ExpireThread(Videobridge videobridge) {
            this.videobridge = new WeakReference<Videobridge>(videobridge);
            this.setDaemon(true);
            this.setName(this.getClass().getName());
        }

        private void expire(Videobridge videobridge) {
            for (Conference conference : videobridge.getConferences()) {
                Content[] contents = conference.getContents();
                if (contents.length == 0) {
                    if (conference.getLastActivityTime() + 60000L >= System.currentTimeMillis()) continue;
                    try {
                        conference.expire();
                        continue;
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("Failed to expire conference " + conference.getID() + "!"), t);
                        if (!(t instanceof ThreadDeath)) continue;
                        throw (ThreadDeath)t;
                    }
                }
                for (Content content : conference.getContents()) {
                    Channel[] channels = content.getChannels();
                    if (channels.length == 0) {
                        if (content.getLastActivityTime() + 60000L >= System.currentTimeMillis()) continue;
                        try {
                            content.expire();
                            continue;
                        }
                        catch (Throwable t) {
                            logger.warn((Object)("Failed to expire content " + content.getName() + " of conference " + conference.getID() + "!"), t);
                            if (!(t instanceof ThreadDeath)) continue;
                            throw (ThreadDeath)t;
                        }
                    }
                    for (Channel channel : channels) {
                        if (channel.getLastActivityTime() + 1000L * (long)channel.getExpire() >= System.currentTimeMillis()) continue;
                        try {
                            channel.expire();
                        }
                        catch (Throwable t) {
                            logger.warn((Object)("Failed to expire channel " + channel.getID() + " of content " + content.getName() + " of conference " + conference.getID() + "!"), t);
                            if (!(t instanceof ThreadDeath)) continue;
                            throw (ThreadDeath)t;
                        }
                    }
                }
            }
        }

        public void run() {
            Videobridge videobridge;
            long wakeup = -1L;
            long sleep = 60000L;
            while ((videobridge = (Videobridge)this.videobridge.get()) != null) {
                long slept;
                long now = System.currentTimeMillis();
                if (wakeup != -1L && (slept = now - wakeup) < 60000L) {
                    boolean interrupted = false;
                    try {
                        Thread.sleep(60000L - slept);
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                wakeup = now;
                try {
                    this.expire(videobridge);
                }
                catch (Throwable t) {
                    logger.error((Object)"Failed to complete an iteration of automatic expiry of channels, contents, and conferences!", t);
                    if (!(t instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)t;
                }
            }
        }
    }
}

