/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.IOException;
import java.net.DatagramPacket;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.media.Buffer;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import org.ice4j.socket.DatagramPacketFilter;
import org.jitsi.impl.neomedia.RTPConnectorOutputStream;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.protocol.PushBufferStreamAdapter;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;

public abstract class RTPConnectorInputStream
implements PushSourceStream,
Runnable {
    private static final Object[] EMPTY_CONTROLS = new Object[0];
    public static final int PACKET_RECEIVE_BUFFER_LENGTH = 4096;
    private static final Logger logger = Logger.getLogger(RTPConnectorInputStream.class);
    private final byte[] buffer = new byte[4096];
    protected boolean closed;
    private DatagramPacketFilter[] datagramPacketFilters;
    protected boolean ioError = false;
    private RawPacket pkt;
    private final Object pktSyncRoot = new Object();
    private final PushBufferStream pushBufferStream;
    private final Queue<RawPacket[]> rawPacketArrayPool = new LinkedBlockingQueue<RawPacket[]>();
    private final Queue<RawPacket> rawPacketPool = new LinkedBlockingQueue<RawPacket>();
    protected Thread receiverThread = null;
    private SourceTransferHandler transferHandler;

    public RTPConnectorInputStream() {
        this.addDatagramPacketFilter(new DatagramPacketFilter(){
            private long numberOfPackets = 0L;

            public boolean accept(DatagramPacket p) {
                PacketLoggingService packetLogging;
                ++this.numberOfPackets;
                if (RTPConnectorOutputStream.logPacket(this.numberOfPackets) && (packetLogging = LibJitsi.getPacketLoggingService()) != null && packetLogging.isLoggingEnabled(PacketLoggingService.ProtocolName.RTP)) {
                    RTPConnectorInputStream.this.doLogPacket(p);
                }
                return true;
            }
        });
        this.pushBufferStream = new PushBufferStreamAdapter(this, null){

            @Override
            protected int doRead(Buffer buffer, byte[] data, int offset, int length) throws IOException {
                return RTPConnectorInputStream.this.read(buffer, data, offset, length);
            }
        };
    }

    public synchronized void close() {
    }

    protected RawPacket[] createRawPacket(DatagramPacket datagramPacket) {
        RawPacket pkt;
        RawPacket[] pkts = this.rawPacketArrayPool.poll();
        if (pkts == null) {
            pkts = new RawPacket[1];
        }
        if ((pkt = this.rawPacketPool.poll()) == null) {
            pkt = new RawPacket();
        }
        pkt.setBuffer(datagramPacket.getData());
        pkt.setFlags(0);
        pkt.setLength(datagramPacket.getLength());
        pkt.setOffset(datagramPacket.getOffset());
        pkts[0] = pkt;
        return pkts;
    }

    @Override
    public boolean endOfStream() {
        return false;
    }

    @Override
    public ContentDescriptor getContentDescriptor() {
        return null;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public Object getControl(String controlType) {
        if (PushBufferStream.class.getName().equals(controlType)) {
            return this.pushBufferStream;
        }
        return null;
    }

    @Override
    public Object[] getControls() {
        return EMPTY_CONTROLS;
    }

    @Override
    public int getMinimumTransferSize() {
        return 2048;
    }

    private void poolRawPacket(RawPacket pkt) {
        pkt.setBuffer(null);
        pkt.setFlags(0);
        pkt.setLength(0);
        pkt.setOffset(0);
        this.rawPacketPool.offer(pkt);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.read(null, buffer, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int read(Buffer buffer, byte[] data, int offset, int length) throws IOException {
        int pktLength;
        RawPacket pkt;
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (this.ioError) {
            return -1;
        }
        Object object = this.pktSyncRoot;
        synchronized (object) {
            pkt = this.pkt;
            this.pkt = null;
        }
        if (pkt == null) {
            pktLength = 0;
        } else {
            boolean poolPkt = true;
            try {
                pktLength = pkt.getLength();
                if (length < pktLength) {
                    poolPkt = false;
                    throw new IOException("Input buffer not big enough for " + pktLength);
                }
                byte[] pktBuffer = pkt.getBuffer();
                if (pktBuffer == null) {
                    throw new NullPointerException("pkt.buffer null, pkt.length " + pktLength + ", pkt.offset " + pkt.getOffset());
                }
                System.arraycopy(pkt.getBuffer(), pkt.getOffset(), data, offset, pktLength);
                if (buffer != null) {
                    buffer.setFlags(pkt.getFlags());
                }
            }
            finally {
                if (!poolPkt) {
                    Object object2 = this.pktSyncRoot;
                    synchronized (object2) {
                        if (this.pkt == null) {
                            this.pkt = pkt;
                        } else {
                            poolPkt = true;
                        }
                    }
                }
                if (poolPkt) {
                    this.poolRawPacket(pkt);
                }
            }
        }
        return pktLength;
    }

    protected abstract void doLogPacket(DatagramPacket var1);

    protected abstract void receivePacket(DatagramPacket var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DatagramPacket p = new DatagramPacket(this.buffer, 0, 4096);
        while (!this.closed) {
            boolean accept;
            try {
                if (OSUtils.IS_ANDROID) {
                    p.setLength(4096);
                }
                this.receivePacket(p);
            }
            catch (IOException e) {
                this.ioError = true;
                break;
            }
            DatagramPacketFilter[] datagramPacketFilters = this.getDatagramPacketFilters();
            if (datagramPacketFilters == null) {
                accept = true;
            } else {
                accept = true;
                for (int i = 0; i < datagramPacketFilters.length; ++i) {
                    try {
                        if (datagramPacketFilters[i].accept(p)) continue;
                        accept = false;
                        break;
                    }
                    catch (Throwable t) {
                        if (!(t instanceof ThreadDeath)) continue;
                        throw (ThreadDeath)t;
                    }
                }
            }
            if (!accept) continue;
            RawPacket[] pkts = this.createRawPacket(p);
            for (int i = 0; i < pkts.length; ++i) {
                RawPacket oldPkt;
                RawPacket pkt = pkts[i];
                pkts[i] = null;
                if (pkt == null) continue;
                if (pkt.isInvalid()) {
                    this.poolRawPacket(pkt);
                    continue;
                }
                Object object = this.pktSyncRoot;
                synchronized (object) {
                    oldPkt = this.pkt;
                    this.pkt = pkt;
                }
                if (oldPkt != null) {
                    this.poolRawPacket(oldPkt);
                }
                if (this.transferHandler == null || this.closed) continue;
                try {
                    this.transferHandler.transferData(this);
                    continue;
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    logger.warn("An RTP packet may have not been fully handled.", t);
                }
            }
            this.rawPacketArrayPool.offer(pkts);
        }
    }

    @Override
    public void setTransferHandler(SourceTransferHandler transferHandler) {
        if (!this.closed) {
            this.transferHandler = transferHandler;
        }
    }

    public void setPriority(int priority) {
    }

    public synchronized DatagramPacketFilter[] getDatagramPacketFilters() {
        return this.datagramPacketFilters;
    }

    public synchronized void addDatagramPacketFilter(DatagramPacketFilter datagramPacketFilter) {
        if (datagramPacketFilter == null) {
            throw new NullPointerException("datagramPacketFilter");
        }
        if (this.datagramPacketFilters == null) {
            this.datagramPacketFilters = new DatagramPacketFilter[]{datagramPacketFilter};
        } else {
            int length = this.datagramPacketFilters.length;
            for (int i = 0; i < length; ++i) {
                if (!datagramPacketFilter.equals(this.datagramPacketFilters[i])) continue;
                return;
            }
            DatagramPacketFilter[] newDatagramPacketFilters = new DatagramPacketFilter[length + 1];
            System.arraycopy(this.datagramPacketFilters, 0, newDatagramPacketFilters, 0, length);
            newDatagramPacketFilters[length] = datagramPacketFilter;
            this.datagramPacketFilters = newDatagramPacketFilters;
        }
    }
}

