/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectJabberImpl;
import net.java.sip.communicator.service.protocol.WhiteboardPoint;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObjectImage;
import net.java.sip.communicator.util.Base64;
import net.java.sip.communicator.util.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WhiteboardObjectImageJabberImpl
extends WhiteboardObjectJabberImpl
implements WhiteboardObjectImage {
    private static final Logger logger = Logger.getLogger(WhiteboardObjectImageJabberImpl.class);
    private double height;
    private double width;
    private WhiteboardPoint whiteboardPoint;
    private byte[] background;

    public WhiteboardObjectImageJabberImpl() {
    }

    public WhiteboardObjectImageJabberImpl(String xml) {
        block7: {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
                Document doc = builder.parse(in);
                Element e = doc.getDocumentElement();
                String elementName = e.getNodeName();
                if (elementName.equals("image")) {
                    String id = e.getAttribute("id");
                    double x = Double.parseDouble(e.getAttribute("x"));
                    double y = Double.parseDouble(e.getAttribute("y"));
                    double width = Double.parseDouble(e.getAttribute("width"));
                    double height = Double.parseDouble(e.getAttribute("height"));
                    String img = e.getTextContent();
                    this.setID(id);
                    this.setWhiteboardPoint(new WhiteboardPoint(x, y));
                    this.setWidth(width);
                    this.setHeight(height);
                    this.setBackgroundImage(Base64.decode((String)img));
                }
            }
            catch (ParserConfigurationException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem WhiteboardObject : " + xml));
                }
            }
            catch (IOException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem WhiteboardObject : " + xml));
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block7;
                logger.debug((Object)("Problem WhiteboardObject : " + xml));
            }
        }
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public WhiteboardPoint getWhiteboardPoint() {
        return this.whiteboardPoint;
    }

    public void setWhiteboardPoint(WhiteboardPoint whiteboardPoint) {
        this.whiteboardPoint = whiteboardPoint;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setBackgroundImage(byte[] background) {
        this.background = background;
    }

    public byte[] getBackgroundImage() {
        return this.background;
    }

    @Override
    public String toXML() {
        String s = "<image id=\"#id\" x=\"#x\" y=\"#y\" width=\"#w\" height=\"#h\">#img</image>";
        s = s.replaceAll("#id", this.getID());
        WhiteboardPoint p = this.getWhiteboardPoint();
        s = s.replaceAll("#x", "" + p.getX());
        s = s.replaceAll("#y", "" + p.getY());
        s = s.replaceAll("#w", "" + this.getWidth());
        s = s.replaceAll("#h", "" + this.getHeight());
        String img = new String(Base64.encode((byte[])this.getBackgroundImage()));
        s = s.replaceAll("#img", img);
        return s;
    }
}

