/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jrobin.core.Archive;
import org.jrobin.core.ConsolFuns;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;
import org.jrobin.data.Aggregates;
import org.jrobin.data.DataProcessor;

public class FetchData
implements ConsolFuns {
    private static final String RPN_SOURCE_NAME = "WHERE THE SPEECHLES UNITE IN A SILENT ACCORD";
    private FetchRequest request;
    private String[] dsNames;
    private long[] timestamps;
    private double[][] values;
    private Archive matchingArchive;
    private long arcStep;
    private long arcEndTime;

    FetchData(Archive archive, FetchRequest fetchRequest) throws IOException {
        this.matchingArchive = archive;
        this.arcStep = archive.getArcStep();
        this.arcEndTime = archive.getEndTime();
        this.dsNames = fetchRequest.getFilter();
        if (this.dsNames == null) {
            this.dsNames = archive.getParentDb().getDsNames();
        }
        this.request = fetchRequest;
    }

    void setTimestamps(long[] lArray) {
        this.timestamps = lArray;
    }

    void setValues(double[][] dArray) {
        this.values = dArray;
    }

    public int getRowCount() {
        return this.timestamps.length;
    }

    public int getColumnCount() {
        return this.dsNames.length;
    }

    public long[] getTimestamps() {
        return this.timestamps;
    }

    public long getStep() {
        return this.timestamps[1] - this.timestamps[0];
    }

    public double[] getValues(int n) {
        return this.values[n];
    }

    public double[][] getValues() {
        return this.values;
    }

    public double[] getValues(String string) throws RrdException {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!string.equals(this.dsNames[i])) continue;
            return this.getValues(i);
        }
        throw new RrdException("Datasource [" + string + "] not found");
    }

    public double[] getRpnValues(String string) throws RrdException {
        DataProcessor dataProcessor = this.createDataProcessor(string);
        return dataProcessor.getValues(RPN_SOURCE_NAME);
    }

    public FetchRequest getRequest() {
        return this.request;
    }

    public long getFirstTimestamp() {
        return this.timestamps[0];
    }

    public long getLastTimestamp() {
        return this.timestamps[this.timestamps.length - 1];
    }

    public Archive getMatchingArchive() {
        return this.matchingArchive;
    }

    public String[] getDsNames() {
        return this.dsNames;
    }

    public int getDsIndex(String string) {
        for (int i = 0; i < this.dsNames.length; ++i) {
            if (!this.dsNames[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.getRowCount(); ++i) {
            stringBuffer.append(this.timestamps[i]);
            stringBuffer.append(":  ");
            for (int j = 0; j < this.getColumnCount(); ++j) {
                stringBuffer.append(Util.formatDouble(this.values[j][i], true));
                stringBuffer.append("  ");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FetchData.padWithBlanks("", 10));
        stringBuffer.append(" ");
        String[] stringArray = this.dsNames;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            stringBuffer.append(FetchData.padWithBlanks(string, 18));
        }
        stringBuffer.append("\n \n");
        for (int i = 0; i < this.timestamps.length; ++i) {
            stringBuffer.append(FetchData.padWithBlanks("" + this.timestamps[i], 10));
            stringBuffer.append(":");
            for (n = 0; n < this.dsNames.length; ++n) {
                double d = this.values[n][i];
                String string = Double.isNaN(d) ? "nan" : Util.formatDouble(d);
                stringBuffer.append(FetchData.padWithBlanks(string, 18));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static String padWithBlanks(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = n - string.length();
        while (n2-- > 0) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public double getAggregate(String string, String string2) throws RrdException {
        DataProcessor dataProcessor = this.createDataProcessor(null);
        return dataProcessor.getAggregate(string, string2);
    }

    public double getAggregate(String string, String string2, String string3) throws RrdException, IOException {
        string3 = string3.replaceAll("value", string);
        return this.getRpnAggregate(string3, string2);
    }

    public double getRpnAggregate(String string, String string2) throws RrdException {
        DataProcessor dataProcessor = this.createDataProcessor(string);
        return dataProcessor.getAggregate(RPN_SOURCE_NAME, string2);
    }

    public Aggregates getAggregates(String string) throws RrdException {
        DataProcessor dataProcessor = this.createDataProcessor(null);
        return dataProcessor.getAggregates(string);
    }

    public Aggregates getRpnAggregates(String string) throws RrdException, IOException {
        DataProcessor dataProcessor = this.createDataProcessor(string);
        return dataProcessor.getAggregates(RPN_SOURCE_NAME);
    }

    public double get95Percentile(String string) throws RrdException {
        DataProcessor dataProcessor = this.createDataProcessor(null);
        return dataProcessor.get95Percentile(string);
    }

    public double getRpn95Percentile(String string) throws RrdException {
        DataProcessor dataProcessor = this.createDataProcessor(string);
        return dataProcessor.get95Percentile(RPN_SOURCE_NAME);
    }

    public void exportXml(OutputStream outputStream) throws IOException {
        XmlWriter xmlWriter = new XmlWriter(outputStream);
        xmlWriter.startTag("fetch_data");
        xmlWriter.startTag("request");
        xmlWriter.writeTag("file", this.request.getParentDb().getPath());
        xmlWriter.writeComment(Util.getDate(this.request.getFetchStart()));
        xmlWriter.writeTag("start", this.request.getFetchStart());
        xmlWriter.writeComment(Util.getDate(this.request.getFetchEnd()));
        xmlWriter.writeTag("end", this.request.getFetchEnd());
        xmlWriter.writeTag("resolution", this.request.getResolution());
        xmlWriter.writeTag("cf", this.request.getConsolFun());
        xmlWriter.closeTag();
        xmlWriter.startTag("datasources");
        String[] stringArray = this.dsNames;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            xmlWriter.writeTag("name", string);
        }
        xmlWriter.closeTag();
        xmlWriter.startTag("data");
        for (int i = 0; i < this.timestamps.length; ++i) {
            xmlWriter.startTag("row");
            xmlWriter.writeComment(Util.getDate(this.timestamps[i]));
            xmlWriter.writeTag("timestamp", this.timestamps[i]);
            xmlWriter.startTag("values");
            for (n = 0; n < this.dsNames.length; ++n) {
                xmlWriter.writeTag("v", this.values[n][i]);
            }
            xmlWriter.closeTag();
            xmlWriter.closeTag();
        }
        xmlWriter.closeTag();
        xmlWriter.closeTag();
        xmlWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportXml(String string) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            this.exportXml(fileOutputStream);
        }
        finally {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
    }

    public String exportXml() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.exportXml(byteArrayOutputStream);
        return byteArrayOutputStream.toString();
    }

    public long getArcStep() {
        return this.arcStep;
    }

    public long getArcEndTime() {
        return this.arcEndTime;
    }

    private DataProcessor createDataProcessor(String string) throws RrdException {
        DataProcessor dataProcessor = new DataProcessor(this.request.getFetchStart(), this.request.getFetchEnd());
        for (String string2 : this.dsNames) {
            dataProcessor.addDatasource(string2, this);
        }
        if (string != null) {
            dataProcessor.addDatasource(RPN_SOURCE_NAME, string);
            try {
                dataProcessor.processData();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Impossible error: " + iOException);
            }
        }
        return dataProcessor;
    }
}

