/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONTokener;

public class JSONObject {
    private HashMap myHashMap;
    public static final Object NULL = new Null();

    public JSONObject() {
        this.myHashMap = new HashMap();
    }

    public JSONObject(JSONObject jSONObject, String[] stringArray) throws JSONException {
        this();
        for (int i = 0; i < stringArray.length; ++i) {
            this.putOpt(stringArray[i], jSONObject.opt(stringArray[i]));
        }
    }

    public JSONObject(JSONTokener jSONTokener) throws JSONException {
        this();
        if (jSONTokener.nextClean() != '{') {
            throw jSONTokener.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = jSONTokener.nextClean();
            switch (c) {
                case '\u0000': {
                    throw jSONTokener.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            jSONTokener.back();
            String string = jSONTokener.nextValue().toString();
            c = jSONTokener.nextClean();
            if (c == '=') {
                if (jSONTokener.next() != '>') {
                    jSONTokener.back();
                }
            } else if (c != ':') {
                throw jSONTokener.syntaxError("Expected a ':' after a key");
            }
            this.myHashMap.put(string, jSONTokener.nextValue());
            switch (jSONTokener.nextClean()) {
                case ',': 
                case ';': {
                    if (jSONTokener.nextClean() == '}') {
                        return;
                    }
                    jSONTokener.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw jSONTokener.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Map map) {
        this.myHashMap = new HashMap(map);
    }

    public JSONObject(String string) throws JSONException {
        this(new JSONTokener(string));
    }

    public JSONObject accumulate(String string, Object object) throws JSONException {
        JSONObject.testValidity(object);
        Object object2 = this.opt(string);
        if (object2 == null) {
            this.put(string, object);
        } else if (object2 instanceof JSONArray) {
            ((JSONArray)object2).put(object);
        } else {
            this.put(string, new JSONArray().put(object2).put(object));
        }
        return this;
    }

    public Object get(String string) throws JSONException {
        Object object = this.opt(string);
        if (object == null) {
            throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] not found.");
        }
        return object;
    }

    public boolean getBoolean(String string) throws JSONException {
        Object object = this.get(string);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a Boolean.");
    }

    public double getDouble(String string) throws JSONException {
        Object object = this.get(string);
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble((String)object);
        }
        catch (Exception exception) {
            throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a number.");
        }
    }

    public int getInt(String string) throws JSONException {
        Object object = this.get(string);
        return object instanceof Number ? ((Number)object).intValue() : (int)this.getDouble(string);
    }

    public JSONArray getJSONArray(String string) throws JSONException {
        Object object = this.get(string);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String string) throws JSONException {
        Object object = this.get(string);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a JSONObject.");
    }

    public long getLong(String string) throws JSONException {
        Object object = this.get(string);
        return object instanceof Number ? ((Number)object).longValue() : (long)this.getDouble(string);
    }

    public String getString(String string) throws JSONException {
        return this.get(string).toString();
    }

    public boolean has(String string) {
        return this.myHashMap.containsKey(string);
    }

    public boolean isNull(String string) {
        return NULL.equals(this.opt(string));
    }

    public Iterator keys() {
        return this.myHashMap.keySet().iterator();
    }

    public int length() {
        return this.myHashMap.size();
    }

    public JSONArray names() {
        JSONArray jSONArray = new JSONArray();
        Iterator iterator = this.keys();
        while (iterator.hasNext()) {
            jSONArray.put(iterator.next());
        }
        return jSONArray.length() == 0 ? null : jSONArray;
    }

    public static String numberToString(Number number) throws JSONException {
        if (number == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(number);
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public Object opt(String string) {
        return string == null ? null : this.myHashMap.get(string);
    }

    public boolean optBoolean(String string) {
        return this.optBoolean(string, false);
    }

    public boolean optBoolean(String string, boolean bl) {
        try {
            return this.getBoolean(string);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public double optDouble(String string) {
        return this.optDouble(string, Double.NaN);
    }

    public double optDouble(String string, double d) {
        try {
            Object object = this.opt(string);
            return object instanceof Number ? ((Number)object).doubleValue() : new Double((String)object).doubleValue();
        }
        catch (Exception exception) {
            return d;
        }
    }

    public int optInt(String string) {
        return this.optInt(string, 0);
    }

    public int optInt(String string, int n) {
        try {
            return this.getInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public JSONArray optJSONArray(String string) {
        Object object = this.opt(string);
        return object instanceof JSONArray ? (JSONArray)object : null;
    }

    public JSONObject optJSONObject(String string) {
        Object object = this.opt(string);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    public long optLong(String string) {
        return this.optLong(string, 0L);
    }

    public long optLong(String string, long l) {
        try {
            return this.getLong(string);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public String optString(String string) {
        return this.optString(string, "");
    }

    public String optString(String string, String string2) {
        Object object = this.opt(string);
        return object != null ? object.toString() : string2;
    }

    public JSONObject put(String string, boolean bl) throws JSONException {
        this.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONObject put(String string, double d) throws JSONException {
        this.put(string, new Double(d));
        return this;
    }

    public JSONObject put(String string, int n) throws JSONException {
        this.put(string, new Integer(n));
        return this;
    }

    public JSONObject put(String string, long l) throws JSONException {
        this.put(string, new Long(l));
        return this;
    }

    public JSONObject put(String string, Object object) throws JSONException {
        if (string == null) {
            throw new JSONException("Null key.");
        }
        if (object != null) {
            JSONObject.testValidity(object);
            this.myHashMap.put(string, object);
        } else {
            this.remove(string);
        }
        return this;
    }

    public JSONObject putOpt(String string, Object object) throws JSONException {
        if (string != null && object != null) {
            this.put(string, object);
        }
        return this;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 4);
        stringBuffer.append('\"');
        block9: for (int i = 0; i < n; ++i) {
            char c2 = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block9;
                }
                case '/': {
                    if (c2 == '<') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                    continue block9;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String string2 = "000" + Integer.toHexString(c);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4));
                        continue block9;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public Object remove(String string) {
        return this.myHashMap.remove(string);
    }

    static void testValidity(Object object) throws JSONException {
        if (object != null) {
            if (object instanceof Double) {
                if (((Double)object).isInfinite() || ((Double)object).isNaN()) {
                    throw new JSONException("JSON does not allow non-finite numbers");
                }
            } else if (object instanceof Float && (((Float)object).isInfinite() || ((Float)object).isNaN())) {
                throw new JSONException("JSON does not allow non-finite numbers.");
            }
        }
    }

    public JSONArray toJSONArray(JSONArray jSONArray) throws JSONException {
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        JSONArray jSONArray2 = new JSONArray();
        for (int i = 0; i < jSONArray.length(); ++i) {
            jSONArray2.put(this.opt(jSONArray.getString(i)));
        }
        return jSONArray2;
    }

    public String toString() {
        try {
            Iterator iterator = this.keys();
            StringBuffer stringBuffer = new StringBuffer("{");
            while (iterator.hasNext()) {
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(',');
                }
                Object e = iterator.next();
                stringBuffer.append(JSONObject.quote(e.toString()));
                stringBuffer.append(':');
                stringBuffer.append(JSONObject.valueToString(this.myHashMap.get(e)));
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(int n) throws JSONException {
        return this.toString(n, 0);
    }

    String toString(int n, int n2) throws JSONException {
        int n3 = this.length();
        if (n3 == 0) {
            return "{}";
        }
        Iterator iterator = this.keys();
        StringBuffer stringBuffer = new StringBuffer("{");
        int n4 = n2 + n;
        if (n3 == 1) {
            Object e = iterator.next();
            stringBuffer.append(JSONObject.quote(e.toString()));
            stringBuffer.append(": ");
            stringBuffer.append(JSONObject.valueToString(this.myHashMap.get(e), n, n2));
        } else {
            int n5;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(",\n");
                } else {
                    stringBuffer.append('\n');
                }
                for (n5 = 0; n5 < n4; ++n5) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(JSONObject.quote(e.toString()));
                stringBuffer.append(": ");
                stringBuffer.append(JSONObject.valueToString(this.myHashMap.get(e), n, n4));
            }
            if (stringBuffer.length() > 1) {
                stringBuffer.append('\n');
                for (n5 = 0; n5 < n2; ++n5) {
                    stringBuffer.append(' ');
                }
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    static String valueToString(Object object) throws JSONException {
        if (object == null || object.equals(null)) {
            return "null";
        }
        if (object instanceof Number) {
            return JSONObject.numberToString((Number)object);
        }
        if (object instanceof Boolean || object instanceof JSONObject || object instanceof JSONArray) {
            return object.toString();
        }
        return JSONObject.quote(object.toString());
    }

    static String valueToString(Object object, int n, int n2) throws JSONException {
        if (object == null || object.equals(null)) {
            return "null";
        }
        if (object instanceof Number) {
            return JSONObject.numberToString((Number)object);
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof JSONObject) {
            return ((JSONObject)object).toString(n, n2);
        }
        if (object instanceof JSONArray) {
            return ((JSONArray)object).toString(n, n2);
        }
        return JSONObject.quote(object.toString());
    }

    public Writer write(Writer writer) throws JSONException {
        try {
            boolean bl = false;
            Iterator iterator = this.keys();
            writer.write(123);
            while (iterator.hasNext()) {
                if (bl) {
                    writer.write(44);
                }
                Object e = iterator.next();
                writer.write(JSONObject.quote(e.toString()));
                writer.write(58);
                Object v = this.myHashMap.get(e);
                if (v instanceof JSONObject) {
                    ((JSONObject)v).write(writer);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(v));
                }
                bl = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

