/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr;

import f00f.net.irc.martyr.IRCConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class InputHandler
extends Thread {
    static Logger log = Logger.getLogger(InputHandler.class);
    private BufferedReader reader;
    private IRCConnection connection;
    private final LinkedList<String> messages;
    private final Object eventMonitor;
    private static int serialGen = 0;
    private int serialNumber = serialGen++;
    private boolean doShutdown = false;

    public InputHandler(BufferedReader reader, IRCConnection connection, Object eventMonitor) {
        super("InputHandler");
        this.reader = reader;
        this.connection = connection;
        this.messages = new LinkedList();
        this.eventMonitor = eventMonitor;
        log.debug((Object)"IRCConnection: New");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalShutdown() {
        InputHandler inputHandler = this;
        synchronized (inputHandler) {
            this.doShutdown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pendingMessages() {
        LinkedList<String> linkedList = this.messages;
        synchronized (linkedList) {
            return !this.messages.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage() {
        LinkedList<String> linkedList = this.messages;
        synchronized (linkedList) {
            return this.messages.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        log.debug((Object)"IRCConnection: Running");
        try {
            while (true) {
                Object object = this;
                synchronized (object) {
                    if (this.doShutdown) {
                        return;
                    }
                }
                String str = this.reader.readLine();
                if (str == null) {
                    this.connection.socketError(new IOException("Socket disconnected"));
                    return;
                }
                object = this.messages;
                synchronized (object) {
                    this.messages.addLast(str);
                }
                object = this.eventMonitor;
                synchronized (object) {
                    this.eventMonitor.notifyAll();
                }
                continue;
                break;
            }
        }
        catch (IOException ioe) {
            if (this.doShutdown) {
                return;
            }
            this.connection.socketError(ioe);
            return;
        }
        finally {
            log.debug((Object)"IRCConnection: Input handler has DIED!");
        }
    }

    public String toString() {
        return "InputHandler[" + this.serialNumber + "]";
    }
}

