/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rtcp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;
import net.sf.fmj.media.rtp.AbstractRTCPReportBuilder;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPReportBuilder;
import net.sf.fmj.media.rtp.RTCPSDES;
import net.sf.fmj.media.rtp.RTCPSDESItem;
import net.sf.fmj.media.rtp.RTCPSDESPacket;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import net.sf.fmj.media.rtp.RTCPTransmitter;
import net.sf.fmj.media.rtp.SSRCInfo;
import org.jitsi.impl.neomedia.rtcp.RTCPFBPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPREMBPacket;
import org.jitsi.impl.neomedia.rtp.translator.Payload;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.RTCPPacketTransformer;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.VideoMediaStream;
import org.jitsi.service.neomedia.rtp.RemoteBitrateEstimator;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.rtcp.BridgeRTCPTerminationStrategy;
import org.jitsi.videobridge.rtcp.RTCPPacketPayload;
import org.jitsi.videobridge.simulcast.SimulcastLayer;

@Deprecated
public class MaxThroughputBridgeRTCPTerminationStrategy
extends AbstractRTCPReportBuilder
implements BridgeRTCPTerminationStrategy,
RTCPPacketTransformer {
    private static final Logger logger = Logger.getLogger(MaxThroughputBridgeRTCPTerminationStrategy.class);
    private Conference conference;
    private RTPTranslator rtpTranslator;

    private RTCPSDES createRTCPSDES(RTCPTransmitter rtcpTransmitter, int ssrc) {
        String cname;
        SSRCInfo ssrcInfo = (SSRCInfo)rtcpTransmitter.cache.cache.get(ssrc);
        RTCPSDES rtcpSDES = null;
        if (ssrcInfo != null && (cname = ssrcInfo.getCNAME()) != null) {
            rtcpSDES = new RTCPSDES();
            rtcpSDES.ssrc = ssrc;
            rtcpSDES.items = new RTCPSDESItem[]{new RTCPSDESItem(1, cname)};
        }
        return rtcpSDES;
    }

    public RTCPPacketTransformer getRTCPPacketTransformer() {
        return this;
    }

    public RTCPReportBuilder getRTCPReportBuilder() {
        return this;
    }

    private RTCPReportBlock[] makeReceiverReports(VideoChannel videoChannel, RTCPTransmitter rtcpTransmitter, long time) {
        SortedSet<SimulcastLayer> layers = videoChannel.getSimulcastManager().getSimulcastLayers();
        ArrayList<RTCPReportBlock> receiverReports = new ArrayList<RTCPReportBlock>(layers.size());
        for (SimulcastLayer layer : layers) {
            int ssrc = (int)layer.getPrimarySSRC();
            SSRCInfo info = (SSRCInfo)rtcpTransmitter.cache.cache.get(ssrc);
            if (info != null) {
                RTCPReportBlock receiverReport = info.makeReceiverReport(time);
                receiverReports.add(receiverReport);
                continue;
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("FMJ has no information for SSRC " + ((long)ssrc & 0xFFFFFFFFL) + " (" + ssrc + ")"));
        }
        return receiverReports.toArray(new RTCPReportBlock[receiverReports.size()]);
    }

    private RTCPREMBPacket makeREMBPacket(VideoChannel videoChannel, int localSSRC) {
        if (videoChannel == null) {
            throw new IllegalArgumentException("videoChannel");
        }
        long mediaSSRC = 0L;
        RemoteBitrateEstimator remoteBitrateEstimator = ((VideoMediaStream)videoChannel.getStream()).getRemoteBitrateEstimator();
        Collection ssrcs = remoteBitrateEstimator.getSsrcs();
        long[] dest = new long[ssrcs.size()];
        int i = 0;
        for (Integer ssrc : ssrcs) {
            dest[i++] = (long)ssrc.intValue() & 0xFFFFFFFFL;
        }
        long bitrate = remoteBitrateEstimator.getLatestEstimate();
        if (bitrate == -1L) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Estimated bitrate: " + bitrate));
        }
        return new RTCPREMBPacket((long)localSSRC & 0xFFFFFFFFL, 0L, bitrate, dest);
    }

    public RTCPPacket[] makeReports(RTCPTransmitter rtcpTransmitter) {
        RTPTranslator rtpTranslator = this.rtpTranslator;
        if (!(rtpTranslator instanceof RTPTranslatorImpl)) {
            return null;
        }
        long time = System.currentTimeMillis();
        RTPTranslatorImpl rtpTranslatorImpl = (RTPTranslatorImpl)rtpTranslator;
        int localSSRC = (int)rtpTranslatorImpl.getLocalSSRC(null);
        for (Endpoint endpoint : this.conference.getEndpoints()) {
            for (RtpChannel channel : endpoint.getChannels(MediaType.VIDEO)) {
                RTCPPacket[] packets = this.makeReports((VideoChannel)channel, rtcpTransmitter, time, localSSRC);
                if (packets == null || packets.length == 0) continue;
                RTCPCompoundPacket compoundPacket = new RTCPCompoundPacket(packets);
                RTCPPacketPayload payload = new RTCPPacketPayload(compoundPacket);
                rtpTranslatorImpl.writeControlPayload((Payload)payload, channel.getStream());
                rtcpTransmitter.onRTCPCompoundPacketSent(compoundPacket);
            }
        }
        return null;
    }

    private RTCPPacket[] makeReports(VideoChannel videoChannel, RTCPTransmitter rtcpTransmitter, long time, int localSSRC) {
        RTCPPacket[] rTCPPacketArray;
        RTCPReportBlock[] receiverReports = this.makeReceiverReports(videoChannel, rtcpTransmitter, time);
        RTCPRRPacket rr = new RTCPRRPacket(localSSRC, receiverReports);
        RTCPREMBPacket remb = this.makeREMBPacket(videoChannel, localSSRC);
        if (remb != null && logger.isDebugEnabled()) {
            logger.debug((Object)remb);
        }
        ArrayList<RTCPSDES> sdesChunks = new ArrayList<RTCPSDES>(1 + receiverReports.length);
        RTCPSDES sdesChunk = this.createRTCPSDES(rtcpTransmitter, localSSRC);
        if (sdesChunk != null) {
            sdesChunks.add(sdesChunk);
        }
        long[] dest = new long[receiverReports.length];
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = receiverReports[i].getSSRC();
        }
        for (long ssrc : dest) {
            sdesChunk = this.createRTCPSDES(rtcpTransmitter, (int)ssrc);
            if (sdesChunk == null) continue;
            sdesChunks.add(sdesChunk);
        }
        RTCPSDESPacket sdes = new RTCPSDESPacket(sdesChunks.toArray(new RTCPSDES[sdesChunks.size()]));
        if (remb != null) {
            RTCPPacket[] rTCPPacketArray2 = new RTCPPacket[3];
            rTCPPacketArray2[0] = rr;
            rTCPPacketArray2[1] = remb;
            rTCPPacketArray = rTCPPacketArray2;
            rTCPPacketArray2[2] = sdes;
        } else {
            RTCPPacket[] rTCPPacketArray3 = new RTCPPacket[2];
            rTCPPacketArray3[0] = rr;
            rTCPPacketArray = rTCPPacketArray3;
            rTCPPacketArray3[1] = sdes;
        }
        return rTCPPacketArray;
    }

    public void setConference(Conference conference) {
        this.conference = conference;
    }

    public Conference getConference() {
        return this.conference;
    }

    public void setRTPTranslator(RTPTranslator translator) {
        this.rtpTranslator = translator;
    }

    public RTPTranslator getRTPTranslator() {
        return this.rtpTranslator;
    }

    public RTCPCompoundPacket transformRTCPPacket(RTCPCompoundPacket inPacket) {
        if (inPacket == null) {
            return inPacket;
        }
        RTCPPacket[] inPackets = inPacket.packets;
        if (inPackets == null || inPackets.length == 0) {
            return inPacket;
        }
        ArrayList<Object> outPackets = new ArrayList<Object>(inPackets.length);
        block8: for (RTCPPacket p : inPackets) {
            switch (p.type) {
                case 201: {
                    continue block8;
                }
                case 200: {
                    RTCPSRPacket sr = (RTCPSRPacket)p;
                    sr.reports = new RTCPReportBlock[0];
                    outPackets.add(sr);
                    continue block8;
                }
                case 206: {
                    RTCPFBPacket psfb = (RTCPFBPacket)p;
                    switch (psfb.fmt) {
                        case 15: {
                            continue block8;
                        }
                    }
                    outPackets.add(psfb);
                    continue block8;
                }
                default: {
                    outPackets.add(p);
                }
            }
        }
        RTCPCompoundPacket outPacket = outPackets.isEmpty() ? null : new RTCPCompoundPacket(outPackets.toArray(new RTCPPacket[outPackets.size()]));
        return outPacket;
    }
}

