/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp.termination.strategies;

import java.util.Vector;
import net.sf.fmj.media.rtp.DefaultRTCPReportBuilderImpl;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPReportBuilder;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPFBPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPREMBPacket;
import org.jitsi.service.neomedia.RTCPPacketTransformer;
import org.jitsi.service.neomedia.RTCPTerminationStrategy;
import org.jitsi.service.neomedia.RTPTranslator;

public class MaxThroughputRTCPTerminationStrategy
implements RTCPTerminationStrategy,
RTCPPacketTransformer {
    private final RTCPReportBuilder reportBuilder = new DefaultRTCPReportBuilderImpl();
    public static final int MAX_MANTISSA = 262143;
    public static final int MAX_EXP = 63;

    @Override
    public RTCPCompoundPacket transformRTCPPacket(RTCPCompoundPacket inPacket) {
        if (inPacket == null || inPacket.packets == null || inPacket.packets.length == 0) {
            return inPacket;
        }
        Vector<RTCPPacket> outPackets = new Vector<RTCPPacket>();
        block8: for (RTCPPacket p : inPacket.packets) {
            switch (p.type) {
                case 201: {
                    continue block8;
                }
                case 200: {
                    RTCPSRPacket sr = (RTCPSRPacket)p;
                    outPackets.add(sr);
                    sr.reports = new RTCPReportBlock[0];
                    continue block8;
                }
                case 206: {
                    RTCPFBPacket psfb = (RTCPFBPacket)p;
                    switch (psfb.fmt) {
                        case 15: {
                            RTCPREMBPacket remb = (RTCPREMBPacket)p;
                            remb.mantissa = 262143;
                            remb.exp = 63;
                            outPackets.add(remb);
                            continue block8;
                        }
                    }
                    outPackets.add(psfb);
                    continue block8;
                }
                default: {
                    outPackets.add(p);
                }
            }
        }
        Object[] outarr = new RTCPPacket[outPackets.size()];
        outPackets.copyInto(outarr);
        RTCPCompoundPacket outPacket = new RTCPCompoundPacket((RTCPPacket[])outarr);
        return outPacket;
    }

    @Override
    public RTCPPacketTransformer getRTCPPacketTransformer() {
        return this;
    }

    @Override
    public RTCPReportBuilder getRTCPReportBuilder() {
        return this.reportBuilder;
    }

    @Override
    public void setRTPTranslator(RTPTranslator translator) {
    }

    @Override
    public RTPTranslator getRTPTranslator() {
        return null;
    }
}

