/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video.jpeg;

import com.lti.utils.StringUtils;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.JPEGFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.AbstractCodec;
import net.sf.fmj.media.codec.video.jpeg.JpegRTPHeader;
import net.sf.fmj.media.codec.video.jpeg.RFC2035;
import net.sf.fmj.utility.ArrayUtility;
import net.sf.fmj.utility.LoggingStringUtils;

public class DePacketizer
extends AbstractCodec
implements Codec {
    private static final boolean COMPARE_WITH_BASELINE = false;
    private static final boolean TRACE = false;
    private static final boolean EXIT_AFTER_ONE_FRAME = false;
    private static final int MAX_ACTIVE_FRAME_ASSEMBLERS = 3;
    private final Format[] supportedInputFormats = new Format[]{new VideoFormat("jpeg/rtp", null, -1, Format.byteArray, -1.0f)};
    private final Format[] supportedOutputFormats = new Format[]{new JPEGFormat()};
    private Codec baselineCodec;
    private static final BufferFragmentOffsetComparator bufferFragmentOffsetComparator = new BufferFragmentOffsetComparator();
    private static final int MAX_DUMP_SIZE = 200000;
    private long lastRTPtimestamp = -1L;
    private long lastTimestamp;
    private final FrameAssemblerCollection frameAssemblers = new FrameAssemblerCollection();

    private static int buildJFIFHeader(byte[] byArray, int n) {
        byArray[n++] = -1;
        byArray[n++] = -32;
        byArray[n++] = 0;
        byArray[n++] = 16;
        byArray[n++] = 74;
        byArray[n++] = 70;
        byArray[n++] = 73;
        byArray[n++] = 70;
        byArray[n++] = 0;
        byArray[n++] = 1;
        byArray[n++] = 1;
        byArray[n++] = 0;
        byArray[n++] = 0;
        byArray[n++] = 1;
        byArray[n++] = 0;
        byArray[n++] = 1;
        byArray[n++] = 0;
        byArray[n++] = 0;
        return n;
    }

    private static void dump(Buffer buffer, String string) {
    }

    private static String dump(byte[] byArray, int n, int n2) {
        return StringUtils.dump(byArray, n, n + n2);
    }

    private static boolean hasJPEGHeaders(byte[] byArray, int n, int n2) {
        if (n2 < 2) {
            throw new IllegalArgumentException();
        }
        if (byArray[n++] != -1) {
            return false;
        }
        return byArray[n++] == -40;
    }

    private static boolean hasJPEGTrailer(byte[] byArray, int n, int n2) {
        if (n2 < 2) {
            throw new IllegalArgumentException();
        }
        if (byArray[n++] != -1) {
            return false;
        }
        return byArray[n++] == -39;
    }

    private static void zeroData(byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byArray[i] = 0;
        }
    }

    public void close() {
        if (this.baselineCodec != null) {
            this.baselineCodec.close();
        }
        super.close();
        this.frameAssemblers.clear();
    }

    public Object getControl(String string) {
        if (this.baselineCodec != null) {
            return this.baselineCodec.getControl(string);
        }
        return super.getControl(string);
    }

    public Object[] getControls() {
        if (this.baselineCodec != null) {
            return this.baselineCodec.getControls();
        }
        return super.getControls();
    }

    public String getName() {
        return "JPEG DePacketizer";
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedInputFormats;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.supportedOutputFormats;
        }
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension dimension = new Dimension(320, 240);
        Format[] formatArray = new Format[]{new JPEGFormat(videoFormat.getSize() != null ? videoFormat.getSize() : dimension, -1, Format.byteArray, -1.0f, -1, -1)};
        if (this.baselineCodec != null) {
            Format[] formatArray2 = this.baselineCodec.getSupportedOutputFormats(format);
            System.out.println("input:  " + LoggingStringUtils.formatToStr(format));
            for (int i = 0; i < formatArray2.length; ++i) {
                System.out.println("output: " + LoggingStringUtils.formatToStr(formatArray2[0]));
            }
        }
        return formatArray;
    }

    public void open() throws ResourceUnavailableException {
        if (this.baselineCodec != null) {
            this.baselineCodec.open();
        }
        super.open();
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!buffer.isDiscard()) {
            if (this.baselineCodec != null) {
                int n = this.baselineCodec.process(buffer, buffer2);
            }
            JpegRTPHeader jpegRTPHeader = buffer.getLength() >= 8 ? JpegRTPHeader.parse((byte[])buffer.getData(), buffer.getOffset()) : null;
            long l = buffer.getTimeStamp();
            boolean bl = (buffer.getFlags() & 0x800) != 0;
            FrameAssembler frameAssembler = this.frameAssemblers.findOrAdd(l);
            frameAssembler.put((Buffer)buffer.clone());
            if (frameAssembler.complete()) {
                Buffer buffer3 = this.baselineCodec == null ? buffer2 : new Buffer();
                int n = frameAssembler.copyToBuffer(buffer3);
                this.frameAssemblers.remove(l);
                this.frameAssemblers.removeOlderThan(l);
                if (this.lastRTPtimestamp == -1L) {
                    this.lastRTPtimestamp = buffer.getTimeStamp();
                    this.lastTimestamp = System.nanoTime();
                }
                return 0;
            }
            this.frameAssemblers.removeAllButNewestN(3);
            buffer2.setDiscard(true);
            return 4;
        }
        buffer2.setDiscard(true);
        return 4;
    }

    public void reset() {
        if (this.baselineCodec != null) {
            this.baselineCodec.reset();
        }
        super.reset();
        this.frameAssemblers.clear();
    }

    public Format setInputFormat(Format format) {
        if (this.baselineCodec != null) {
            super.setInputFormat(format);
            return this.baselineCodec.setInputFormat(format);
        }
        return super.setInputFormat(format);
    }

    public Format setOutputFormat(Format format) {
        if (this.baselineCodec != null) {
            super.setOutputFormat(format);
            return this.baselineCodec.setOutputFormat(format);
        }
        return super.setOutputFormat(format);
    }

    private static class FrameAssemblerCollection {
        private Map<Long, FrameAssembler> frameAssemblers = new HashMap<Long, FrameAssembler>();

        private FrameAssemblerCollection() {
        }

        public void clear() {
            this.frameAssemblers.clear();
        }

        public FrameAssembler findOrAdd(long l) {
            Long l2 = l;
            FrameAssembler frameAssembler = this.frameAssemblers.get(l2);
            if (frameAssembler == null) {
                frameAssembler = new FrameAssembler();
                this.frameAssemblers.put(l2, frameAssembler);
            }
            return frameAssembler;
        }

        public long getOldestTimestamp() {
            long l = -1L;
            for (Long l2 : this.frameAssemblers.keySet()) {
                if (l >= 0L && l2 >= l) continue;
                l = l2;
            }
            return l;
        }

        public void remove(long l) {
            this.frameAssemblers.remove(l);
        }

        public void removeAllButNewestN(int n) {
            while (this.frameAssemblers.size() > n) {
                long l = this.getOldestTimestamp();
                if (l < 0L) {
                    throw new RuntimeException();
                }
                Long l2 = l;
                FrameAssembler frameAssembler = this.frameAssemblers.get(l2);
                String string = frameAssembler.complete() ? "complete" : "incomplete";
                this.frameAssemblers.remove(l2);
            }
        }

        public void removeOlderThan(long l) {
            Iterator<Map.Entry<Long, FrameAssembler>> iterator = this.frameAssemblers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, FrameAssembler> entry = iterator.next();
                Long l2 = entry.getKey();
                if (l2 >= l) continue;
                iterator.remove();
            }
        }
    }

    static class FrameAssembler {
        private final List<Buffer> list = new ArrayList<Buffer>();
        private boolean rtpMarker;

        FrameAssembler() {
        }

        public boolean complete() {
            if (!this.rtpMarker) {
                return false;
            }
            if (this.list.size() <= 0) {
                return false;
            }
            return this.contiguous();
        }

        private boolean contiguous() {
            int n = 0;
            for (Buffer buffer : this.list) {
                JpegRTPHeader jpegRTPHeader = this.parseJpegRTPHeader(buffer);
                int n2 = 0;
                if (jpegRTPHeader.getType() > 63) {
                    n2 += 4;
                }
                if (jpegRTPHeader.getQ() >= 128) {
                    int n3 = 0;
                    int n4 = buffer.getOffset() + 8 + n2 + 2;
                    byte[] byArray = (byte[])buffer.getData();
                    n3 = byArray[n4++] & 0xFF;
                    n3 <<= 8;
                    n3 |= byArray[n4] & 0xFF;
                    n2 += (n3 += 4);
                }
                if (jpegRTPHeader.getFragmentOffset() != n) {
                    return false;
                }
                n += buffer.getLength() - 8 - n2;
            }
            return true;
        }

        public int copyToBuffer(Buffer buffer) {
            int n;
            byte[] byArray;
            if (!this.rtpMarker) {
                throw new IllegalStateException();
            }
            if (this.list.size() <= 0) {
                throw new IllegalStateException();
            }
            Buffer buffer2 = this.list.get(0);
            boolean bl = !DePacketizer.hasJPEGHeaders((byte[])buffer2.getData(), buffer2.getOffset() + 8, buffer2.getLength() - 8);
            int n2 = bl ? 1024 : 0;
            int n3 = this.frameLength();
            int n4 = buffer2.getOffset();
            int n5 = 0;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            byte[] byArray4 = (byte[])buffer2.getData();
            if (buffer.getData() != null && ((byte[])buffer.getData()).length >= n3 + n2 + 2) {
                byArray = (byte[])buffer.getData();
                DePacketizer.zeroData(byArray);
            } else {
                byArray = new byte[n3 + n2 + 2];
            }
            int n6 = 0;
            if (bl) {
                byArray[n6++] = -1;
                byArray[n6++] = -40;
                n6 = DePacketizer.buildJFIFHeader(byArray, n6);
                JpegRTPHeader jpegRTPHeader = this.parseJpegRTPHeader(buffer2);
                n4 += 8;
                if (jpegRTPHeader.getType() >= 64 && jpegRTPHeader.getType() <= 127) {
                    n5 = byArray4[n4++] & 0xFF;
                    n5 <<= 8;
                    n5 |= byArray4[n4++] & 0xFF;
                    n4 += 2;
                }
                if (jpegRTPHeader.getQ() > 127) {
                    n4 += 2;
                    n = byArray4[n4++] & 0xFF;
                    n <<= 8;
                    byArray2 = ArrayUtility.copyOfRange(byArray4, n4, n4 + (n |= byArray4[n4++] & 0xFF) / 2);
                    byArray3 = ArrayUtility.copyOfRange(byArray4, n4 += n / 2, n4 + n / 2);
                    n4 += n / 2;
                }
                n6 = RFC2035.MakeHeaders(false, byArray, n6, jpegRTPHeader.getType(), jpegRTPHeader.getQ(), jpegRTPHeader.getWidthInBlocks(), jpegRTPHeader.getHeightInBlocks(), byArray2, byArray3, n5);
            }
            for (Buffer buffer3 : this.list) {
                JpegRTPHeader jpegRTPHeader = this.parseJpegRTPHeader(buffer3);
                System.arraycopy(buffer3.getData(), buffer3.getOffset() + 8, byArray, n6 + jpegRTPHeader.getFragmentOffset(), buffer3.getLength() - 8);
            }
            boolean bl2 = !DePacketizer.hasJPEGTrailer(byArray, n6 + n3, 2);
            n = 0;
            if (bl2) {
                byArray[n6 + n3 + n++] = -1;
                byArray[n6 + n3 + n++] = -39;
            }
            buffer.setData(byArray);
            buffer.setLength(n6 + n3 + n);
            buffer.setOffset(0);
            buffer.setRtpTimeStamp(buffer2.getRtpTimeStamp());
            buffer.setTimeStamp(buffer2.getTimeStamp());
            return n6;
        }

        public int frameLength() {
            if (!this.rtpMarker) {
                throw new IllegalStateException();
            }
            if (this.list.size() <= 0) {
                throw new IllegalStateException();
            }
            Buffer buffer = this.list.get(this.list.size() - 1);
            JpegRTPHeader jpegRTPHeader = this.parseJpegRTPHeader(buffer);
            return jpegRTPHeader.getFragmentOffset() + buffer.getLength() - 8;
        }

        private JpegRTPHeader parseJpegRTPHeader(Buffer buffer) {
            return JpegRTPHeader.parse((byte[])buffer.getData(), buffer.getOffset());
        }

        public void put(Buffer buffer) {
            if (!this.rtpMarker) {
                boolean bl = this.rtpMarker = (buffer.getFlags() & 0x800) != 0;
            }
            if (buffer.getLength() <= 8) {
                return;
            }
            this.list.add(buffer);
            Collections.sort(this.list, bufferFragmentOffsetComparator);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BufferFragmentOffsetComparator
    implements Comparator<Buffer> {
        private BufferFragmentOffsetComparator() {
        }

        @Override
        public int compare(Buffer buffer, Buffer buffer2) {
            if (buffer == null && buffer2 == null) {
                return 0;
            }
            if (buffer == null) {
                return -1;
            }
            if (buffer2 == null) {
                return 1;
            }
            JpegRTPHeader jpegRTPHeader = JpegRTPHeader.parse((byte[])buffer.getData(), buffer.getOffset());
            JpegRTPHeader jpegRTPHeader2 = JpegRTPHeader.parse((byte[])buffer2.getData(), buffer2.getOffset());
            return jpegRTPHeader.getFragmentOffset() - jpegRTPHeader2.getFragmentOffset();
        }
    }
}

