/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.PipelinedMsgParser;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.IOHandler;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.TLSMessageProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.text.ParseException;
import javax.sip.address.Hop;

public final class TLSMessageChannel
extends MessageChannel
implements SIPMessageListener,
Runnable {
    private Socket mySock;
    private PipelinedMsgParser myParser;
    private InputStream myClientInputStream;
    private String key;
    protected boolean isCached;
    protected boolean isRunning;
    private Thread mythread;
    private String myAddress;
    private int myPort;
    private InetAddress peerAddress;
    private int peerPort;
    private String peerProtocol;
    protected int useCount = 0;
    private TLSMessageProcessor tlsMessageProcessor;
    private SIPTransactionStack sipStack;

    protected TLSMessageChannel(Socket socket, SIPTransactionStack sIPTransactionStack, TLSMessageProcessor tLSMessageProcessor) throws IOException {
        if (sIPTransactionStack.isLoggingEnabled()) {
            sIPTransactionStack.logWriter.logDebug("creating new TLSMessageChannel ");
            sIPTransactionStack.logWriter.logStackTrace();
        }
        this.mySock = socket;
        this.peerAddress = this.mySock.getInetAddress();
        this.myAddress = tLSMessageProcessor.getIPAddress().getHostAddress();
        this.myClientInputStream = this.mySock.getInputStream();
        this.mythread = new Thread(this);
        this.mythread.setDaemon(true);
        this.mythread.setName("TLSMessageChannelThread");
        this.sipStack = sIPTransactionStack;
        this.tlsMessageProcessor = tLSMessageProcessor;
        this.myPort = this.tlsMessageProcessor.getPort();
        this.messageProcessor = tLSMessageProcessor;
        this.mythread.start();
    }

    protected TLSMessageChannel(InetAddress inetAddress, int n, SIPTransactionStack sIPTransactionStack, TLSMessageProcessor tLSMessageProcessor) throws IOException {
        if (sIPTransactionStack.isLoggingEnabled()) {
            sIPTransactionStack.logWriter.logDebug("creating new TLSMessageChannel ");
            sIPTransactionStack.logWriter.logStackTrace();
        }
        this.peerAddress = inetAddress;
        this.peerPort = n;
        this.myPort = tLSMessageProcessor.getPort();
        this.peerProtocol = "TLS";
        this.sipStack = sIPTransactionStack;
        this.tlsMessageProcessor = tLSMessageProcessor;
        this.myAddress = tLSMessageProcessor.getIPAddress().getHostAddress();
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TLS");
        this.messageProcessor = tLSMessageProcessor;
    }

    public boolean isReliable() {
        return true;
    }

    public void close() {
        block4: {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("Closing message Channel " + this);
                }
            }
            catch (IOException iOException) {
                if (!this.sipStack.isLoggingEnabled()) break block4;
                this.sipStack.logWriter.logDebug("Error closing socket " + iOException);
            }
        }
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public String getTransport() {
        return "tls";
    }

    public String getPeerAddress() {
        if (this.peerAddress != null) {
            return this.peerAddress.getHostAddress();
        }
        return this.getHost();
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    private void sendMessage(byte[] byArray, boolean bl) throws IOException {
        Socket socket = this.sipStack.ioHandler.sendBytes(this.getMessageProcessor().getIPAddress(), this.peerAddress, this.peerPort, this.peerProtocol, byArray, bl);
        if (socket != this.mySock && socket != null) {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mySock = socket;
            this.myClientInputStream = this.mySock.getInputStream();
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.setName("TLSMessageChannelThread");
            thread.start();
        }
    }

    public void sendMessage(SIPMessage sIPMessage) throws IOException {
        byte[] byArray = sIPMessage.encodeAsBytes();
        long l = System.currentTimeMillis();
        this.sendMessage(byArray, sIPMessage instanceof SIPRequest);
        if (this.sipStack.serverLog.needsLogging(16)) {
            this.logMessage(sIPMessage, this.peerAddress, this.peerPort, l);
        }
    }

    public void sendMessage(byte[] byArray, InetAddress inetAddress, int n, boolean bl) throws IOException {
        if (byArray == null || inetAddress == null) {
            throw new IllegalArgumentException("Null argument");
        }
        Socket socket = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIPAddress(), inetAddress, n, "TLS", byArray, bl);
        if (socket != this.mySock && socket != null) {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mySock = socket;
            this.myClientInputStream = this.mySock.getInputStream();
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.setName("TLSMessageChannelThread");
            thread.start();
        }
    }

    public void handleException(ParseException parseException, SIPMessage sIPMessage, Class clazz, String string, String string2) throws ParseException {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logException(parseException);
        }
        if (clazz != null && (clazz.equals(From.class) || clazz.equals(To.class) || clazz.equals(CSeq.class) || clazz.equals(Via.class) || clazz.equals(CallID.class) || clazz.equals(RequestLine.class) || clazz.equals(StatusLine.class))) {
            this.sipStack.getLogWriter().logDebug("Encountered bad message \n" + string2);
            throw parseException;
        }
        sIPMessage.addUnparsed(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(SIPMessage sIPMessage) throws Exception {
        block31: {
            Object object;
            if (sIPMessage.getFrom() == null || sIPMessage.getTo() == null || sIPMessage.getCallId() == null || sIPMessage.getCSeq() == null || sIPMessage.getViaHeaders() == null) {
                String string = sIPMessage.encode();
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logError("bad message " + string);
                    this.sipStack.logWriter.logError(">>> Dropped Bad Msg");
                }
                return;
            }
            ViaList viaList = sIPMessage.getViaHeaders();
            if (sIPMessage instanceof SIPRequest) {
                Via via = (Via)viaList.getFirst();
                Hop hop = this.sipStack.addressResolver.resolveAddress(via.getHop());
                this.peerPort = hop.getPort();
                this.peerProtocol = via.getTransport();
                try {
                    this.peerAddress = this.mySock.getInetAddress();
                    if (via.hasParameter("rport") || !hop.getHost().equals(this.peerAddress.getHostAddress())) {
                        via.setParameter("received", this.peerAddress.getHostAddress());
                    }
                    via.setParameter("rport", Integer.toString(this.peerPort));
                }
                catch (ParseException parseException) {
                    InternalErrorHandler.handleException(parseException);
                }
                if (!this.isCached) {
                    ((TLSMessageProcessor)this.messageProcessor).cacheMessageChannel(this);
                    this.isCached = true;
                    object = IOHandler.makeKey(this.mySock.getInetAddress(), this.peerPort);
                    this.sipStack.ioHandler.putSocket((String)object, this.mySock);
                }
            }
            long l = System.currentTimeMillis();
            if (sIPMessage instanceof SIPRequest) {
                object = (SIPRequest)sIPMessage;
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("----Processing Message---");
                }
                if (this.sipStack.serverLog.needsLogging(16)) {
                    this.sipStack.serverLog.logMessage(sIPMessage, this.getPeerHostPort().toString(), this.messageProcessor.getIPAddress().getHostAddress() + ":" + this.messageProcessor.getPort(), false, l);
                }
                if (this.sipStack.getMaxMessageSize() > 0 && ((SIPMessage)object).getSize() + (((SIPMessage)object).getContentLength() == null ? 0 : ((SIPMessage)object).getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                    SIPResponse sIPResponse = ((SIPRequest)object).createResponse(513);
                    byte[] byArray = sIPResponse.encodeAsBytes();
                    this.sendMessage(byArray, false);
                    throw new Exception("Message size exceeded");
                }
                ServerRequestInterface serverRequestInterface = this.sipStack.newSIPServerRequest((SIPRequest)object, this);
                if (serverRequestInterface != null) {
                    try {
                        serverRequestInterface.processRequest((SIPRequest)object, this);
                        break block31;
                    }
                    finally {
                        SIPServerTransaction sIPServerTransaction;
                        if (serverRequestInterface instanceof SIPTransaction && !(sIPServerTransaction = (SIPServerTransaction)serverRequestInterface).passToListener()) {
                            ((SIPTransaction)((Object)serverRequestInterface)).releaseSem();
                        }
                    }
                }
                SIPResponse sIPResponse = ((SIPRequest)object).createResponse(503);
                sIPResponse.addHeader(this.sipStack.createServerHeaderForStack());
                RetryAfter retryAfter = new RetryAfter();
                try {
                    retryAfter.setRetryAfter((int)(10.0 * Math.random()));
                    sIPResponse.setHeader(retryAfter);
                    this.sendMessage(sIPResponse);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sipStack.logWriter.logWarning("Dropping message -- could not acquire semaphore");
                break block31;
            }
            object = (SIPResponse)sIPMessage;
            if (((SIPResponse)object).getStatusCode() == 100) {
                ((SIPMessage)object).getTo().removeParameter("tag");
            }
            try {
                ((SIPResponse)object).checkHeaders();
            }
            catch (ParseException parseException) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logError("Dropping Badly formatted response message >>> " + object);
                }
                return;
            }
            if (this.sipStack.getMaxMessageSize() > 0 && ((SIPMessage)object).getSize() + (((SIPMessage)object).getContentLength() == null ? 0 : ((SIPMessage)object).getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("Message size exceeded");
                }
                return;
            }
            ServerResponseInterface serverResponseInterface = this.sipStack.newSIPServerResponse((SIPResponse)object, this);
            if (serverResponseInterface != null) {
                try {
                    serverResponseInterface.processResponse((SIPResponse)object, this);
                    break block31;
                }
                finally {
                    if (serverResponseInterface instanceof SIPTransaction && !((SIPTransaction)((Object)serverResponseInterface)).passToListener()) {
                        ((SIPTransaction)((Object)serverResponseInterface)).releaseSem();
                    }
                }
            }
            this.sipStack.logWriter.logWarning("Could not get semaphore... dropping response");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        var2_1 = null;
        var2_1 = new Pipeline(this.myClientInputStream, this.sipStack.readTimeout, this.sipStack.timer);
        this.myParser = new PipelinedMsgParser(this, var2_1, this.sipStack.getMaxMessageSize());
        this.myParser.processInput();
        var3_2 = 4096;
        ++this.tlsMessageProcessor.useCount;
        this.isRunning = true;
        while (true) lbl-1000:
        // 3 sources

        {
            if ((var5_6 = this.myClientInputStream.read(var4_3 = new byte[var3_2], 0, var3_2)) == -1) {
                var2_1.write("\r\n\r\n".getBytes("UTF-8"));
                try {
                    if (this.sipStack.maxConnections != -1) {
                        var6_11 = this.tlsMessageProcessor;
                        synchronized (var6_11) {
                            --this.tlsMessageProcessor.nConnections;
                            this.tlsMessageProcessor.notify();
                        }
                    }
                    var2_1.close();
                    this.mySock.close();
                }
                catch (IOException var6_12) {
                    // empty catch block
                }
                return;
            }
            try {
                var2_1.write(var4_3, 0, var5_6);
            }
            catch (IOException var4_4) {
                try {
                    var2_1.write("\r\n\r\n".getBytes("UTF-8"));
                }
                catch (Exception var5_7) {
                    // empty catch block
                }
                try {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.logWriter.logDebug("IOException  closing sock " + var4_4);
                    }
                    try {
                        if (this.sipStack.maxConnections != -1) {
                            var5_8 = this.tlsMessageProcessor;
                            synchronized (var5_8) {
                                --this.tlsMessageProcessor.nConnections;
                                this.tlsMessageProcessor.notify();
                            }
                        }
                        this.mySock.close();
                        var2_1.close();
                    }
                    catch (IOException var5_9) {
                    }
                }
                catch (Exception var5_10) {
                    // empty catch block
                }
                return;
            }
            catch (Exception var4_5) {
                InternalErrorHandler.handleException(var4_5);
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            this.isRunning = false;
            this.tlsMessageProcessor.remove(this);
            --this.tlsMessageProcessor.useCount;
        }
    }

    protected void uncache() {
        this.tlsMessageProcessor.remove(this);
    }

    public boolean equals(Object object) {
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        TLSMessageChannel tLSMessageChannel = (TLSMessageChannel)object;
        return this.mySock == tLSMessageChannel.mySock;
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TLS");
        return this.key;
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public int getPeerPacketSourcePort() {
        return this.peerPort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerAddress;
    }

    public boolean isSecure() {
        return true;
    }
}

