/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import javax.sip.header.ContactHeader;

public abstract class MessageChannel {
    protected transient MessageProcessor messageProcessor;

    public abstract void close();

    public abstract SIPTransactionStack getSIPStack();

    public abstract String getTransport();

    public abstract boolean isReliable();

    public abstract boolean isSecure();

    public abstract void sendMessage(SIPMessage var1) throws IOException;

    public abstract String getPeerAddress();

    protected abstract InetAddress getPeerInetAddress();

    protected abstract String getPeerProtocol();

    public abstract int getPeerPort();

    public abstract int getPeerPacketSourcePort();

    public abstract InetAddress getPeerPacketSourceAddress();

    public abstract String getKey();

    public abstract String getViaHost();

    public abstract int getViaPort();

    protected abstract void sendMessage(byte[] var1, InetAddress var2, int var3, boolean var4) throws IOException;

    public String getHost() {
        return this.getMessageProcessor().getIPAddress().getHostAddress();
    }

    public int getPort() {
        if (this.messageProcessor != null) {
            return this.messageProcessor.getPort();
        }
        return -1;
    }

    public void sendMessage(SIPMessage sIPMessage, InetAddress inetAddress, int n) throws IOException {
        long l = System.currentTimeMillis();
        byte[] byArray = sIPMessage.encodeAsBytes();
        this.sendMessage(byArray, inetAddress, n, sIPMessage instanceof SIPRequest);
        this.logMessage(sIPMessage, inetAddress, n, l);
    }

    public String getRawIpSourceAddress() {
        String string = this.getPeerAddress();
        String string2 = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            string2 = inetAddress.getHostAddress();
        }
        catch (Exception exception) {
            InternalErrorHandler.handleException(exception);
        }
        return string2;
    }

    public static String getKey(InetAddress inetAddress, int n, String string) {
        return (string + ":" + inetAddress.getHostAddress() + ":" + n).toLowerCase();
    }

    public static String getKey(HostPort hostPort, String string) {
        return (string + ":" + hostPort.getHost().getHostname() + ":" + hostPort.getPort()).toLowerCase();
    }

    public HostPort getHostPort() {
        HostPort hostPort = new HostPort();
        hostPort.setHost(new Host(this.getHost()));
        hostPort.setPort(this.getPort());
        return hostPort;
    }

    public HostPort getPeerHostPort() {
        HostPort hostPort = new HostPort();
        hostPort.setHost(new Host(this.getPeerAddress()));
        hostPort.setPort(this.getPeerPort());
        return hostPort;
    }

    public Via getViaHeader() {
        Via via = new Via();
        try {
            via.setTransport(this.getTransport());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        via.setSentBy(this.getHostPort());
        return via;
    }

    public HostPort getViaHostPort() {
        HostPort hostPort = new HostPort();
        hostPort.setHost(new Host(this.getViaHost()));
        hostPort.setPort(this.getViaPort());
        return hostPort;
    }

    protected void logMessage(SIPMessage sIPMessage, InetAddress inetAddress, int n, long l) {
        if (!this.getSIPStack().serverLog.needsLogging(16)) {
            return;
        }
        if (n == -1) {
            n = 5060;
        }
        this.getSIPStack().serverLog.logMessage(sIPMessage, this.getHost() + ":" + this.getPort(), inetAddress.getHostAddress().toString() + ":" + n, true, l);
    }

    public void logResponse(SIPResponse sIPResponse, long l, String string) {
        Object object;
        int n = this.getPeerPort();
        if (n == 0 && sIPResponse.getContactHeaders() != null) {
            object = (ContactHeader)sIPResponse.getContactHeaders().getFirst();
            n = ((AddressImpl)object.getAddress()).getPort();
        }
        object = this.getPeerAddress().toString() + ":" + n;
        String string2 = this.getHost() + ":" + this.getPort();
        this.getSIPStack().serverLog.logMessage(sIPResponse, (String)object, string2, string, false, l);
    }

    public MessageProcessor getMessageProcessor() {
        return this.messageProcessor;
    }
}

