/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.HostPort;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.header.AddressParametersHeader;
import gov.nist.javax.sip.header.To;
import java.text.ParseException;
import javax.sip.address.Address;
import javax.sip.header.FromHeader;

public final class From
extends AddressParametersHeader
implements FromHeader {
    private static final long serialVersionUID = -6312727234330643892L;

    public From() {
        super("From");
    }

    public From(To to) {
        super("From");
        this.address = to.address;
        this.parameters = to.parameters;
    }

    public String encode() {
        return this.headerName + ":" + " " + this.encodeBody() + "\r\n";
    }

    protected String encodeBody() {
        String string = "";
        if (this.address.getAddressType() == 2) {
            string = string + "<";
        }
        string = string + this.address.encode();
        if (this.address.getAddressType() == 2) {
            string = string + ">";
        }
        if (!this.parameters.isEmpty()) {
            string = string + ";" + this.parameters.encode();
        }
        return string;
    }

    public HostPort getHostPort() {
        return this.address.getHostPort();
    }

    public String getDisplayName() {
        return this.address.getDisplayName();
    }

    public String getTag() {
        if (this.parameters == null) {
            return null;
        }
        return this.getParameter("tag");
    }

    public boolean hasTag() {
        return this.hasParameter("tag");
    }

    public void removeTag() {
        this.parameters.delete("tag");
    }

    public void setAddress(Address address) {
        this.address = (AddressImpl)address;
    }

    public void setTag(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null tag ");
        }
        if (string.trim().equals("")) {
            throw new ParseException("bad tag", 0);
        }
        this.setParameter("tag", string);
    }

    public String getUserAtHostPort() {
        return this.address.getUserAtHostPort();
    }

    public boolean equals(Object object) {
        return object instanceof FromHeader && super.equals(object);
    }
}

