/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.api.CustomTaskSetup;
import com.install4j.api.FileOptions;
import com.install4j.api.InstallationComponentSetup;
import com.install4j.api.InstallerContext;
import com.install4j.api.ProgressInterface;
import com.install4j.api.ServiceSetup;
import com.install4j.api.UserCanceledException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.InstallerUtil;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.CustomTaskConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.ServiceConfig;
import com.install4j.runtime.installer.fileinst.FileInstaller;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class InstallerContextImpl
extends ContextImpl
implements InstallerContext {
    protected InstallerWizard wizard;
    protected ProgressInterface installerProgressInterface;
    private List installationComponentSetups = new ArrayList();
    private List serviceSetups = new ArrayList();
    private List customTaskSetups = new ArrayList();

    public InstallerContextImpl(InstallerWizard installerWizard, ProgressInterface progressInterface) {
        super(installerWizard == null);
        Object object;
        Iterator iterator;
        Object object2;
        this.wizard = installerWizard;
        this.installerProgressInterface = progressInterface;
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        List list = installerConfig.getComponents();
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            object2 = (ComponentConfig)object3.next();
            iterator = new InstallationComponentSetupImpl((ComponentConfig)object2);
            this.installationComponentSetups.add(iterator);
        }
        object3 = installerConfig.getServices();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            iterator = (ServiceConfig)object2.next();
            object = new ServiceSetupImpl((ServiceConfig)((Object)iterator));
            this.serviceSetups.add(object);
        }
        object2 = installerConfig.getCustomTasks();
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (CustomTaskConfig)iterator.next();
            CustomTaskSetupImpl customTaskSetupImpl = new CustomTaskSetupImpl((CustomTaskConfig)object);
            this.customTaskSetups.add(customTaskSetupImpl);
        }
    }

    public String getMediaName() {
        return InstallerConfig.getCurrentInstance().getMediaName();
    }

    public String getProgramGroup() {
        if (this.wizard != null) {
            return this.wizard.getProgramGroup();
        }
        if (InstallerUtil.isWindows()) {
            return InstallerConfig.getCurrentInstance().getWindowsSpecificConfig().getProgramGroup();
        }
        return null;
    }

    public boolean isCreateMenuAllUsers() {
        if (this.wizard != null) {
            return this.wizard.isCreateMenuAllUsers();
        }
        return true;
    }

    public boolean isCreateMenu() {
        if (this.wizard != null) {
            return this.wizard.isCreateMenu();
        }
        return true;
    }

    public Collection getServiceSetups() {
        return this.serviceSetups;
    }

    public Collection getInstallationComponents() {
        return this.installationComponentSetups;
    }

    public Collection getCustomTasks() {
        return this.customTaskSetups;
    }

    public boolean isCreateDesktopIcon() {
        if (this.wizard != null) {
            return this.wizard.isCreateDesktopIcon();
        }
        if (InstallerUtil.isWindows() || InstallerUtil.isMacOS()) {
            return InstallerConfig.getCurrentInstance().isDesktopIconSelected();
        }
        return false;
    }

    public boolean isCreateQuickLaunchIcon() {
        if (this.wizard != null) {
            return this.wizard.isCreateQuickLaunchIcon();
        }
        if (InstallerUtil.isWindows()) {
            return InstallerConfig.getCurrentInstance().getWindowsSpecificConfig().isQuicklaunchIconSelected();
        }
        return false;
    }

    public File getInstallationDirectory() {
        if (this.wizard != null) {
            return this.wizard.getDestDir();
        }
        return Installer.getInstance().getInstallationDirectory();
    }

    public boolean installFile(File file, File file2) throws UserCanceledException {
        return FileInstaller.getInstance().install(file, file2);
    }

    public boolean installFile(File file, File file2, FileOptions fileOptions) throws UserCanceledException {
        return FileInstaller.getInstance().install(file, file2, fileOptions);
    }

    public void registerUninstallFile(File file) {
        FileInstaller.getInstance().registerUninstallFile(file);
    }

    public boolean installFile(File file, File file2, FileOptions fileOptions, ProgressInterface progressInterface, int n, int n2) throws UserCanceledException {
        if (progressInterface != null) {
            progressInterface = new ProgressAdapter(progressInterface, n, n2);
        }
        return FileInstaller.getInstance().install(file, file2, fileOptions, progressInterface);
    }

    public File getInstallerFile() {
        String string = System.getProperty("exe4j.moduleName");
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    public void abort() {
        Installer.getInstance().abort(this.installerProgressInterface);
    }

    public static class InstallationComponentSetupImpl
    implements InstallationComponentSetup {
        private ComponentConfig componentConfig;

        public InstallationComponentSetupImpl(ComponentConfig componentConfig) {
            this.componentConfig = componentConfig;
        }

        public boolean isSelected() {
            return this.componentConfig.isSelected();
        }

        public void setSelected(boolean bl) {
            this.componentConfig.setSelected(bl);
        }

        public String getDescription() {
            return this.componentConfig.getName();
        }
    }

    public static class CustomTaskSetupImpl
    implements CustomTaskSetup {
        private CustomTaskConfig customTaskConfig;

        public CustomTaskSetupImpl(CustomTaskConfig customTaskConfig) {
            this.customTaskConfig = customTaskConfig;
        }

        public boolean isSelected() {
            return this.customTaskConfig.isSelected();
        }

        public void setSelected(boolean bl) {
            this.customTaskConfig.setSelected(bl);
        }

        public String getId() {
            return this.customTaskConfig.getId();
        }

        public String getDescription() {
            return this.customTaskConfig.getDescription();
        }
    }

    public static class ServiceSetupImpl
    implements ServiceSetup {
        private ServiceConfig serviceConfig;

        public ServiceSetupImpl(ServiceConfig serviceConfig) {
            this.serviceConfig = serviceConfig;
        }

        public boolean isInstall() {
            return this.serviceConfig.isInstall();
        }

        public void setInstall(boolean bl) {
            this.serviceConfig.setInstall(bl);
        }

        public boolean isStartOnBoot() {
            if (InstallerUtil.isWindows()) {
                return this.serviceConfig.getStartupType() == "auto";
            }
            return InstallerUtil.isMacOS();
        }

        public void setStartOnBoot(boolean bl) {
            if (InstallerUtil.isWindows()) {
                String string = bl ? "auto" : "manual";
                this.serviceConfig.setStartupType(string);
            }
        }

        public String getRelativeFileName() {
            if (InstallerUtil.isWindows()) {
                return this.serviceConfig.getFile().replace('/', '\\');
            }
            return this.serviceConfig.getFile().replace('\\', '/');
        }
    }
}

