/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.packet;

import org.jivesoftware.stringprep.IDNA;
import org.jivesoftware.stringprep.Stringprep;

public class JID
implements Comparable {
    private String node;
    private String domain;
    private String resource;

    public JID(String jid) {
        if (jid == null) {
            throw new NullPointerException("JID cannot be null");
        }
        String node = null;
        String domain = null;
        String resource = null;
        int atIndex = jid.indexOf("@");
        int slashIndex = jid.indexOf("/");
        if (atIndex > 0) {
            node = jid.substring(0, atIndex);
        }
        if (atIndex + 1 > jid.length()) {
            throw new IllegalArgumentException("JID with empty domain not valid");
        }
        domain = atIndex < 0 ? (slashIndex > 0 ? jid.substring(0, slashIndex) : jid) : (slashIndex > 0 ? jid.substring(atIndex + 1, slashIndex) : jid.substring(atIndex + 1));
        resource = slashIndex + 1 > jid.length() || slashIndex < 0 ? null : jid.substring(slashIndex + 1);
        this.init(node, domain, resource);
    }

    public JID(String node, String domain, String resource) {
        if (domain == null) {
            throw new NullPointerException("Domain cannot be null");
        }
        this.init(node, domain, resource);
    }

    JID(String jid, Object fake) {
        fake = null;
        if (jid == null) {
            throw new NullPointerException("JID cannot be null");
        }
        int atIndex = jid.indexOf("@");
        int slashIndex = jid.indexOf("/");
        if (atIndex > 0) {
            this.node = jid.substring(0, atIndex);
        }
        if (atIndex + 1 > jid.length()) {
            throw new IllegalArgumentException("JID with empty domain not valid");
        }
        this.domain = atIndex < 0 ? (slashIndex > 0 ? jid.substring(0, slashIndex) : jid) : (slashIndex > 0 ? jid.substring(atIndex + 1, slashIndex) : jid.substring(atIndex + 1));
        this.resource = slashIndex + 1 > jid.length() || slashIndex < 0 ? null : jid.substring(slashIndex + 1);
    }

    private void init(String node, String domain, String resource) {
        if (node != null && node.equals("")) {
            node = null;
        }
        if (resource != null && resource.equals("")) {
            resource = null;
        }
        try {
            this.node = Stringprep.nodeprep(node);
            this.domain = Stringprep.nameprep(IDNA.toASCII(domain), false);
            this.resource = Stringprep.resourceprep(resource);
        }
        catch (Exception e) {
            String errorMessage = "Offending JID:" + node + "@" + domain + "/" + resource;
            throw new IllegalArgumentException("Illegal JID format: " + errorMessage + ": " + e.getMessage());
        }
        if (node != null && node.length() * 2 > 1023) {
            throw new IllegalArgumentException("Node cannot be larger than 1023 bytes. Size is " + node.length() * 2 + " bytes.");
        }
        if (domain.length() * 2 > 1023) {
            throw new IllegalArgumentException("Domain cannot be larger than 1023 bytes. Size is " + domain.length() * 2 + " bytes.");
        }
        if (resource != null && resource.length() * 2 > 1023) {
            throw new IllegalArgumentException("Resource cannot be larger than 1023 bytes. Size is " + resource.length() * 2 + " bytes.");
        }
    }

    public String getNode() {
        return this.node;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getResource() {
        return this.resource;
    }

    public String toBareJID() {
        StringBuffer buf = new StringBuffer();
        if (this.node != null) {
            buf.append(this.node).append("@");
        }
        buf.append(this.domain);
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.node != null) {
            buf.append(this.node).append("@");
        }
        buf.append(this.domain);
        if (this.resource != null) {
            buf.append("/").append(this.resource);
        }
        return buf.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JID)) {
            return false;
        }
        JID jid = (JID)object;
        if (this.node != null ? !this.node.equals(jid.node) : jid.node != null) {
            return false;
        }
        if (!this.domain.equals(jid.domain)) {
            return false;
        }
        return !(this.resource != null ? !this.resource.equals(jid.resource) : jid.resource != null);
    }

    public int compareTo(Object o) {
        if (!(o instanceof JID)) {
            throw new ClassCastException("Ojbect not instanceof JID: " + o);
        }
        JID jid = (JID)o;
        int compare = this.domain.compareTo(jid.domain);
        if (compare == 0 && this.node != null && jid.node != null) {
            compare = this.node.compareTo(jid.node);
        }
        if (compare == 0 && this.resource != null && jid.resource != null) {
            compare = this.resource.compareTo(jid.resource);
        }
        return compare;
    }

    public static boolean equals(String jid1, String jid2) {
        return new JID(jid1).equals(new JID(jid2));
    }
}

