/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.sysactivity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.sysactivity.SystemActivityChangeListener;
import net.java.sip.communicator.service.sysactivity.event.SystemActivityEvent;
import net.java.sip.communicator.util.Logger;

public class SystemActivityEventDispatcher
implements Runnable {
    private static Logger logger = Logger.getLogger(SystemActivityEventDispatcher.class);
    private final List<SystemActivityChangeListener> listeners = new LinkedList<SystemActivityChangeListener>();
    private boolean stopped = true;
    private Thread dispatcherThread = null;
    private Map<SystemActivityEvent, Integer> eventsToDispatch = new LinkedHashMap<SystemActivityEvent, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemActivityChangeListener(SystemActivityChangeListener listener) {
        List<SystemActivityChangeListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
                if (this.dispatcherThread == null) {
                    this.dispatcherThread = new Thread(this);
                    this.dispatcherThread.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSystemActivityChangeListener(SystemActivityChangeListener listener) {
        List<SystemActivityChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Map<SystemActivityEvent, Integer> map = this.eventsToDispatch;
        synchronized (map) {
            this.stopped = true;
            this.eventsToDispatch.notifyAll();
            this.dispatcherThread = null;
        }
    }

    protected void fireSystemActivityEvent(SystemActivityEvent evt) {
        this.fireSystemActivityEvent(evt, 0);
    }

    protected void fireSystemActivityEventCurrentThread(SystemActivityEvent evt) {
        ArrayList<SystemActivityChangeListener> listenersCopy = new ArrayList<SystemActivityChangeListener>(this.listeners);
        for (int i = 0; i < listenersCopy.size(); ++i) {
            this.fireSystemActivityEvent(evt, (SystemActivityChangeListener)listenersCopy.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSystemActivityEvent(SystemActivityEvent evt, int wait) {
        Map<SystemActivityEvent, Integer> map = this.eventsToDispatch;
        synchronized (map) {
            this.eventsToDispatch.put(evt, wait);
            this.eventsToDispatch.notifyAll();
            if (this.dispatcherThread == null && this.listeners.size() > 0) {
                this.dispatcherThread = new Thread(this);
                this.dispatcherThread.start();
            }
        }
    }

    private void fireSystemActivityEvent(SystemActivityEvent evt, SystemActivityChangeListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching SystemActivityEvent Listeners=" + this.listeners.size() + " evt=" + evt));
        }
        if (logger.isInfoEnabled() && (evt.getEventID() == 9 || evt.getEventID() == 12)) {
            logger.info((Object)("Dispatching SystemActivityEvent Listeners=" + this.listeners.size() + " evt=" + evt));
        }
        try {
            listener.activityChanged(evt);
        }
        catch (Throwable e) {
            logger.error((Object)"Error delivering event", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.stopped = false;
            while (!this.stopped) {
                ArrayList<SystemActivityChangeListener> listenersCopy;
                Map.Entry<SystemActivityEvent, Integer> eventToProcess = null;
                Object object = this.eventsToDispatch;
                synchronized (object) {
                    if (this.eventsToDispatch.size() == 0) {
                        try {
                            this.eventsToDispatch.wait();
                        }
                        catch (InterruptedException iex) {
                            // empty catch block
                        }
                    }
                    if (this.listeners.size() == 0) {
                        continue;
                    }
                    listenersCopy = new ArrayList<SystemActivityChangeListener>(this.listeners);
                    Iterator<Map.Entry<SystemActivityEvent, Integer>> iter = this.eventsToDispatch.entrySet().iterator();
                    if (iter.hasNext()) {
                        eventToProcess = iter.next();
                        iter.remove();
                    }
                }
                if (eventToProcess != null && listenersCopy != null) {
                    if (eventToProcess.getValue() > 0) {
                        object = this;
                        synchronized (object) {
                            try {
                                this.wait(eventToProcess.getValue().intValue());
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                    }
                    for (int i = 0; i < listenersCopy.size(); ++i) {
                        this.fireSystemActivityEvent(eventToProcess.getKey(), (SystemActivityChangeListener)listenersCopy.get(i));
                    }
                }
                eventToProcess = null;
                Object var2_3 = null;
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error dispatching thread ended unexpectedly", t);
        }
    }
}

