/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.lang.reflect.Array;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.MultiplexedDatagramSocket;
import org.ice4j.socket.SafeCloseDatagramSocket;
import org.ice4j.socket.SocketReceiveBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplexingDatagramSocket
extends SafeCloseDatagramSocket {
    private static final Logger logger = Logger.getLogger(MultiplexingDatagramSocket.class.getName());
    private static final MultiplexedDatagramSocket[] NO_SOCKETS = new MultiplexedDatagramSocket[0];
    private boolean inReceive = false;
    private int receiveBufferSize;
    private final List<DatagramPacket> received = new SocketReceiveBuffer(){
        private static final long serialVersionUID = 3125772367019091216L;

        public int getReceiveBufferSize() throws SocketException {
            return MultiplexingDatagramSocket.this.getReceiveBufferSize();
        }
    };
    private final Object receiveSyncRoot = new Object();
    private boolean setReceiveBufferSize = false;
    private MultiplexedDatagramSocket[] sockets = NO_SOCKETS;
    private final Object socketsSyncRoot = new Object();
    private int soTimeout = 0;

    static <T> T[] add(T[] array, T element) {
        int length = array.length;
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), length + 1);
        if (length != 0) {
            System.arraycopy(array, 0, newArray, 0, length);
        }
        newArray[length] = element;
        return newArray;
    }

    public static DatagramPacket clone(DatagramPacket p) {
        return MultiplexingDatagramSocket.clone(p, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatagramPacket clone(DatagramPacket p, boolean arraycopy) {
        int port;
        InetAddress address;
        int len;
        int off;
        byte[] data;
        DatagramPacket datagramPacket = p;
        synchronized (datagramPacket) {
            data = p.getData();
            off = p.getOffset();
            len = p.getLength();
            byte[] dataClone = new byte[data.length];
            if (arraycopy && len > 0) {
                int arraycopyLen;
                int arraycopyOff;
                if (off >= 0 && off < data.length && off + len <= data.length) {
                    arraycopyOff = off;
                    arraycopyLen = len;
                } else {
                    arraycopyOff = 0;
                    arraycopyLen = data.length;
                }
                System.arraycopy(data, arraycopyOff, dataClone, arraycopyOff, arraycopyLen);
            }
            data = dataClone;
            address = p.getAddress();
            port = p.getPort();
        }
        DatagramPacket c = new DatagramPacket(data, off, len);
        if (address != null) {
            c.setAddress(address);
        }
        if (port >= 0) {
            c.setPort(port);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(DatagramPacket src, DatagramPacket dest) {
        DatagramPacket datagramPacket = dest;
        synchronized (datagramPacket) {
            dest.setAddress(src.getAddress());
            dest.setPort(src.getPort());
            byte[] srcData = src.getData();
            if (srcData == null) {
                dest.setLength(0);
            } else {
                byte[] destData = dest.getData();
                if (destData == null) {
                    dest.setLength(0);
                } else {
                    int srcLength;
                    int destOffset = dest.getOffset();
                    int destLength = destData.length - destOffset;
                    if (destLength >= (srcLength = src.getLength())) {
                        destLength = srcLength;
                    } else if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "Truncating received DatagramPacket data!");
                    }
                    System.arraycopy(srcData, src.getOffset(), destData, destOffset, destLength);
                    dest.setLength(destLength);
                }
            }
        }
    }

    public MultiplexingDatagramSocket() throws SocketException {
    }

    public MultiplexingDatagramSocket(DatagramSocket delegate) throws SocketException {
        super(delegate);
    }

    public MultiplexingDatagramSocket(int port) throws SocketException {
        super(port);
    }

    public MultiplexingDatagramSocket(int port, InetAddress laddr) throws SocketException {
        super(port, laddr);
    }

    public MultiplexingDatagramSocket(SocketAddress bindaddr) throws SocketException {
        super(bindaddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(MultiplexedDatagramSocket multiplexed) {
        Object object = this.socketsSyncRoot;
        synchronized (object) {
            int socketCount = this.sockets.length;
            for (int i = 0; i < socketCount; ++i) {
                if (!this.sockets[i].equals(multiplexed)) continue;
                if (socketCount == 1) {
                    this.sockets = NO_SOCKETS;
                    break;
                }
                MultiplexedDatagramSocket[] newSockets = new MultiplexedDatagramSocket[socketCount - 1];
                System.arraycopy(this.sockets, 0, newSockets, 0, i);
                System.arraycopy(this.sockets, i + 1, newSockets, i, newSockets.length - i);
                this.sockets = newSockets;
                break;
            }
        }
    }

    public MultiplexedDatagramSocket getSocket(DatagramPacketFilter filter) throws SocketException {
        return this.getSocket(filter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiplexedDatagramSocket getSocket(DatagramPacketFilter filter, boolean create) throws SocketException {
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        Object object = this.socketsSyncRoot;
        synchronized (object) {
            for (MultiplexedDatagramSocket socket : this.sockets) {
                if (!filter.equals(socket.getFilter())) continue;
                return socket;
            }
            if (!create) {
                return null;
            }
            MultiplexedDatagramSocket socket = new MultiplexedDatagramSocket(this, filter);
            this.sockets = MultiplexingDatagramSocket.add(this.sockets, socket);
            return socket;
        }
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
        this.receive(this.received, p, this.soTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive(List<DatagramPacket> received, DatagramPacket p, int timeout) throws IOException {
        long startTime = System.currentTimeMillis();
        DatagramPacket r = null;
        while (true) {
            boolean wait;
            long remainingTimeout;
            long now = System.currentTimeMillis();
            List<DatagramPacket> list = received;
            synchronized (list) {
                if (!received.isEmpty() && (r = received.remove(0)) != null) {
                    break;
                }
            }
            if (timeout > 0) {
                remainingTimeout = (long)timeout - (now - startTime);
                if (remainingTimeout <= 0L) {
                    throw new SocketTimeoutException(Long.toString(remainingTimeout));
                }
            } else {
                remainingTimeout = 1000L;
            }
            Object object = this.receiveSyncRoot;
            synchronized (object) {
                if (this.inReceive) {
                    wait = true;
                } else {
                    wait = false;
                    this.inReceive = true;
                }
            }
            try {
                if (wait) {
                    object = received;
                    synchronized (object) {
                        if (received.isEmpty()) {
                            try {
                                received.wait(remainingTimeout);
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            received.notifyAll();
                        }
                        continue;
                    }
                }
                DatagramPacket c = MultiplexingDatagramSocket.clone(p, false);
                Object object2 = this.receiveSyncRoot;
                synchronized (object2) {
                    block52: {
                        if (this.setReceiveBufferSize) {
                            this.setReceiveBufferSize = false;
                            try {
                                super.setReceiveBufferSize(this.receiveBufferSize);
                            }
                            catch (Throwable t) {
                                if (!(t instanceof ThreadDeath)) break block52;
                                throw (ThreadDeath)t;
                            }
                        }
                    }
                }
                super.receive(c);
                object2 = this.socketsSyncRoot;
                synchronized (object2) {
                    boolean accepted = false;
                    for (MultiplexedDatagramSocket socket : this.sockets) {
                        if (!socket.getFilter().accept(c)) continue;
                        List<DatagramPacket> list2 = socket.received;
                        synchronized (list2) {
                            socket.received.add(accepted ? MultiplexingDatagramSocket.clone(c, true) : c);
                            socket.received.notifyAll();
                        }
                        accepted = true;
                    }
                    if (!accepted) {
                        List<DatagramPacket> list3 = this.received;
                        synchronized (list3) {
                            this.received.add(c);
                            this.received.notifyAll();
                        }
                    }
                    continue;
                }
            }
            finally {
                object = this.receiveSyncRoot;
                synchronized (object) {
                    if (!wait) {
                        this.inReceive = false;
                    }
                }
                continue;
            }
            break;
        }
        MultiplexingDatagramSocket.copy(r, p);
    }

    void receive(MultiplexedDatagramSocket multiplexed, DatagramPacket p) throws IOException {
        this.receive(multiplexed.received, p, multiplexed.getSoTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReceiveBufferSize(int receiveBufferSize) throws SocketException {
        Object object = this.receiveSyncRoot;
        synchronized (object) {
            this.receiveBufferSize = receiveBufferSize;
            if (this.inReceive) {
                this.setReceiveBufferSize = true;
            } else {
                super.setReceiveBufferSize(receiveBufferSize);
                this.setReceiveBufferSize = false;
            }
        }
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        super.setSoTimeout(timeout);
        this.soTimeout = timeout;
    }
}

