/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.gsm;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.AbstractCodec;
import net.sf.fmj.media.codec.audio.gsm.GSMEncoderUtil;

public class Encoder
extends AbstractCodec {
    private Buffer innerBuffer = new Buffer();
    private static final int PCM_BYTES = 320;
    private static final int GSM_BYTES = 33;
    private int innerDataLength = 0;
    byte[] innerContent;
    protected Format[] outputFormats = new Format[]{new AudioFormat("gsm", 8000.0, 8, 1, -1, 1, 264, -1.0, Format.byteArray)};
    private static final boolean TRACE = false;

    public Encoder() {
        this.inputFormats = new Format[]{new AudioFormat("LINEAR", 8000.0, 16, 1, 1, 1, -1, -1.0, Format.byteArray)};
    }

    public void close() {
    }

    public String getName() {
        return "GSM Encoder";
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.outputFormats;
        }
        if (!(input instanceof AudioFormat)) {
            return new Format[]{null};
        }
        AudioFormat inputCast = (AudioFormat)input;
        AudioFormat result = new AudioFormat("gsm", inputCast.getSampleRate(), 8, 1, inputCast.getEndian(), 1, 264, inputCast.getFrameRate(), Format.byteArray);
        return new Format[]{result};
    }

    private byte[] mergeArrays(byte[] arr1, byte[] arr2) {
        if (arr1 == null) {
            return arr2;
        }
        if (arr2 == null) {
            return arr1;
        }
        byte[] merged = new byte[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, merged, 0, arr1.length);
        System.arraycopy(arr2, 0, merged, arr1.length, arr2.length);
        return merged;
    }

    public void open() {
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        int result;
        byte[] inputContent = new byte[inputBuffer.getLength()];
        System.arraycopy(inputBuffer.getData(), inputBuffer.getOffset(), inputContent, 0, inputContent.length);
        byte[] mergedContent = this.mergeArrays((byte[])this.innerBuffer.getData(), inputContent);
        this.innerBuffer.setData(mergedContent);
        this.innerBuffer.setLength(mergedContent.length);
        this.innerDataLength = this.innerBuffer.getLength();
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        byte[] outputBufferData = (byte[])outputBuffer.getData();
        if (outputBufferData == null || outputBufferData.length < 33 * this.innerDataLength / 320) {
            outputBufferData = new byte[33 * (this.innerDataLength / 320)];
            outputBuffer.setData(outputBufferData);
        }
        if (this.innerDataLength < 320) {
            result = 4;
            System.out.println("Not filled");
        } else {
            boolean bigEndian = ((AudioFormat)this.outputFormat).getEndian() == 1;
            outputBufferData = new byte[33 * (this.innerDataLength / 320)];
            outputBuffer.setData(outputBufferData);
            outputBuffer.setLength(33 * (this.innerDataLength / 320));
            GSMEncoderUtil.gsmEncode(bigEndian, (byte[])this.innerBuffer.getData(), this.innerBuffer.getOffset(), this.innerDataLength, outputBufferData);
            outputBuffer.setFormat(this.outputFormat);
            outputBuffer.setData(outputBufferData);
            result = 0;
            byte[] temp = new byte[this.innerDataLength - this.innerDataLength / 320 * 320];
            this.innerContent = (byte[])this.innerBuffer.getData();
            System.arraycopy(this.innerContent, this.innerDataLength / 320 * 320, temp, 0, temp.length);
            outputBuffer.setOffset(0);
            this.innerBuffer.setLength(temp.length);
            this.innerBuffer.setData(temp);
        }
        return result;
    }

    public Format setInputFormat(Format f) {
        return super.setInputFormat(f);
    }

    public Format setOutputFormat(Format f) {
        return super.setOutputFormat(f);
    }
}

