/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.AbstractCodec;
import net.sf.fmj.media.util.BufferToImage;
import net.sf.fmj.media.util.ImageToBuffer;

public class ImageScaler
extends AbstractCodec
implements Codec {
    private final Dimension DIMENSION = null;
    private final Format[] supportedInputFormats = new Format[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, -1, -1, -1, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, -1, -1, -1, -1)};
    private final Format[] supportedOutputFormats = new Format[]{new RGBFormat(this.DIMENSION, -1, Format.intArray, -1.0f, -1, -1, -1, -1)};
    private BufferToImage bufferToImage;

    public Format[] getSupportedInputFormats() {
        return this.supportedInputFormats;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.supportedOutputFormats;
        }
        VideoFormat videoFormat = (VideoFormat)format;
        Format[] formatArray = new Format[]{new RGBFormat(this.DIMENSION, -1, Format.intArray, -1.0f, -1, -1, -1, -1)};
        return formatArray;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        BufferedImage bufferedImage = (BufferedImage)this.bufferToImage.createImage(buffer);
        Dimension dimension = ((VideoFormat)this.inputFormat).getSize();
        Dimension dimension2 = ((VideoFormat)this.outputFormat).getSize();
        double d = (double)dimension2.width / (double)dimension.width;
        double d2 = (double)dimension2.height / (double)dimension.height;
        BufferedImage bufferedImage2 = this.scale(bufferedImage, d, d2);
        System.out.println("scaled: " + bufferedImage2.getWidth() + "x" + bufferedImage2.getHeight());
        Buffer buffer3 = ImageToBuffer.createBuffer(bufferedImage2, ((VideoFormat)this.outputFormat).getFrameRate());
        buffer2.setData(buffer3.getData());
        buffer2.setLength(buffer3.getLength());
        buffer2.setOffset(buffer3.getOffset());
        buffer2.setFormat(buffer3.getFormat());
        return 0;
    }

    private BufferedImage scale(BufferedImage bufferedImage, double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d, d2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 3);
        return affineTransformOp.filter(bufferedImage, null);
    }

    public Format setInputFormat(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        if (videoFormat.getSize() == null) {
            return null;
        }
        this.bufferToImage = new BufferToImage((VideoFormat)format);
        return super.setInputFormat(format);
    }
}

