/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.alaw;

import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.AbstractCodec;
import net.sf.fmj.media.codec.audio.alaw.ALawEncoderUtil;
import net.sf.fmj.utility.LoggerSingleton;

public class Encoder
extends AbstractCodec {
    private static final Logger logger = LoggerSingleton.logger;
    protected Format[] outputFormats = new Format[]{new AudioFormat("alaw", -1.0, 8, 1, -1, 1, 8, -1.0, Format.byteArray)};
    private static final boolean TRACE = false;

    public Encoder() {
        this.inputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, -1, 1, 16, -1.0, Format.byteArray)};
    }

    public void close() {
    }

    public String getName() {
        return "ALAW Encoder";
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (!(format instanceof AudioFormat)) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + format);
            return new Format[]{null};
        }
        AudioFormat audioFormat = (AudioFormat)format;
        if (!audioFormat.getEncoding().equals("LINEAR") || audioFormat.getSampleSizeInBits() != 16 && audioFormat.getSampleSizeInBits() != -1 || audioFormat.getChannels() != 1 && audioFormat.getChannels() != -1 || audioFormat.getSigned() != 1 && audioFormat.getSigned() != -1 || audioFormat.getFrameSizeInBits() != 16 && audioFormat.getFrameSizeInBits() != -1 || audioFormat.getDataType() != null && audioFormat.getDataType() != Format.byteArray) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + format);
            return new Format[]{null};
        }
        AudioFormat audioFormat2 = new AudioFormat("alaw", audioFormat.getSampleRate(), 8, 1, audioFormat.getEndian(), 1, 8, audioFormat.getFrameRate(), Format.byteArray);
        return new Format[]{audioFormat2};
    }

    public void open() {
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        byte[] byArray = (byte[])buffer2.getData();
        if (byArray == null || byArray.length < buffer.getLength() / 2) {
            byArray = new byte[buffer.getLength() / 2];
            buffer2.setData(byArray);
        }
        boolean bl = ((AudioFormat)buffer.getFormat()).getEndian() == 1;
        ALawEncoderUtil.aLawEncode(bl, (byte[])buffer.getData(), buffer.getOffset(), buffer.getLength(), byArray);
        buffer2.setLength(buffer.getLength() / 2);
        buffer2.setOffset(0);
        buffer2.setFormat(this.outputFormat);
        return 0;
    }

    public Format setInputFormat(Format format) {
        return super.setInputFormat(format);
    }

    public Format setOutputFormat(Format format) {
        return super.setOutputFormat(format);
    }
}

