/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.media.Duration;
import javax.media.Time;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergingPullDataSource
extends PullDataSource {
    protected final List<PullDataSource> sources;

    public MergingPullDataSource(List<PullDataSource> list) {
        this.sources = list;
    }

    @Override
    public void connect() throws IOException {
        for (PullDataSource pullDataSource : this.sources) {
            pullDataSource.connect();
        }
    }

    @Override
    public void disconnect() {
        for (PullDataSource pullDataSource : this.sources) {
            pullDataSource.disconnect();
        }
    }

    @Override
    public String getContentType() {
        for (int i = 0; i < this.sources.size(); ++i) {
            if (this.sources.get(i).getContentType().equals(this.sources.get(0).getContentType())) continue;
            return "application.mixed-data";
        }
        return this.sources.get(0).getContentType();
    }

    @Override
    public Object getControl(String string) {
        for (PullDataSource pullDataSource : this.sources) {
            Object object = pullDataSource.getControl(string);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @Override
    public Object[] getControls() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (PullDataSource pullDataSource : this.sources) {
            for (Object object : pullDataSource.getControls()) {
                arrayList.add(object);
            }
        }
        return arrayList.toArray(new Object[0]);
    }

    @Override
    public Time getDuration() {
        ArrayList<Time> arrayList = new ArrayList<Time>();
        for (PullDataSource object : this.sources) {
            arrayList.add(object.getDuration());
        }
        for (Time time : arrayList) {
            if (time.getNanoseconds() != Duration.DURATION_UNKNOWN.getNanoseconds()) continue;
            return Duration.DURATION_UNKNOWN;
        }
        for (Time time : arrayList) {
            if (time.getNanoseconds() != Duration.DURATION_UNBOUNDED.getNanoseconds()) continue;
            return Duration.DURATION_UNBOUNDED;
        }
        long l = -1L;
        for (Time time : arrayList) {
            if (time.getNanoseconds() <= l) continue;
            l = time.getNanoseconds();
        }
        if (l < 0L) {
            return Duration.DURATION_UNKNOWN;
        }
        return new Time(l);
    }

    @Override
    public PullSourceStream[] getStreams() {
        ArrayList<PullSourceStream> arrayList = new ArrayList<PullSourceStream>();
        for (PullDataSource pullDataSource : this.sources) {
            for (PullSourceStream pullSourceStream : pullDataSource.getStreams()) {
                arrayList.add(pullSourceStream);
            }
        }
        return arrayList.toArray(new PullSourceStream[0]);
    }

    @Override
    public void start() throws IOException {
        for (PullDataSource pullDataSource : this.sources) {
            pullDataSource.start();
        }
    }

    @Override
    public void stop() throws IOException {
        for (PullDataSource pullDataSource : this.sources) {
            pullDataSource.stop();
        }
    }
}

