/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.whack;

import java.util.Hashtable;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.net.SocketFactory;
import org.jivesoftware.whack.ExternalComponent;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;
import org.xmpp.component.ComponentManager;
import org.xmpp.component.Log;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;

public class ExternalComponentManager
implements ComponentManager {
    private String domain;
    private int port;
    private String defaultSecretKey;
    private Map<String, String> secretKeys = new Hashtable<String, String>();
    Preferences preferences = Preferences.userRoot();
    private String preferencesPrefix;
    private Map<String, ExternalComponent> componentsByDomain = new Hashtable<String, ExternalComponent>();
    private Map<Component, ExternalComponent> components = new Hashtable<Component, ExternalComponent>();

    public ExternalComponentManager(String domain) {
        this(domain, 5222);
    }

    public ExternalComponentManager(String domain, int port) {
        this.domain = domain;
        this.port = port;
        this.preferencesPrefix = "whack." + domain + ".";
    }

    public void setSecretKey(String subdomain, String secretKey) {
        this.secretKeys.put(subdomain, secretKey);
    }

    public String getSecretKey(String subdomain) {
        String secretKey = this.secretKeys.get(subdomain);
        if (secretKey == null) {
            secretKey = this.defaultSecretKey;
        }
        return secretKey;
    }

    public void setDefaultSecretKey(String secretKey) {
        this.defaultSecretKey = secretKey;
    }

    public void addComponent(String subdomain, Component component) throws ComponentException {
        String secretKey = this.secretKeys.get(subdomain);
        if (secretKey == null) {
            secretKey = this.defaultSecretKey;
        }
        ExternalComponent externalComponent = new ExternalComponent(component, this);
        externalComponent.connect(this.domain, this.port, SocketFactory.getDefault(), subdomain);
        JID componentJID = new JID(null, subdomain + this.domain, null);
        externalComponent.initialize(componentJID, this);
        this.componentsByDomain.put(subdomain, externalComponent);
        this.components.put(component, externalComponent);
    }

    public void removeComponent(String subdomain) throws ComponentException {
        ExternalComponent externalComponent = this.componentsByDomain.remove(subdomain);
        this.components.remove(externalComponent.getComponent());
        if (externalComponent != null) {
            externalComponent.shutdown();
        }
    }

    public void sendPacket(Component component, Packet packet) {
        this.components.get(component).send(packet);
    }

    public String getProperty(String name) {
        return this.preferences.get(this.preferencesPrefix + name, null);
    }

    public void setProperty(String name, String value) {
        this.preferences.put(this.preferencesPrefix + name, value);
    }

    public boolean isExternalMode() {
        return true;
    }

    public Log getLog() {
        return null;
    }
}

