/*
 * Decompiled with CFR 0.152.
 */
package org.iso_relax.dispatcher.impl;

import org.iso_relax.dispatcher.Dispatcher;
import org.iso_relax.dispatcher.ElementDecl;
import org.iso_relax.dispatcher.IslandSchema;
import org.iso_relax.dispatcher.IslandVerifier;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class IgnoreVerifier
extends DefaultHandler
implements IslandVerifier {
    private final ElementDecl[] rules;
    private final String namespaceToIgnore;
    private Dispatcher dispatcher;

    public IgnoreVerifier(String namespaceToIgnore, ElementDecl[] assignedRules) {
        this.namespaceToIgnore = namespaceToIgnore;
        this.rules = assignedRules;
    }

    public ElementDecl[] endIsland() {
        return this.rules;
    }

    public void endChildIsland(String uri, ElementDecl[] assignedLabels) {
    }

    public void setDispatcher(Dispatcher disp) {
        this.dispatcher = disp;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.namespaceToIgnore.equals(namespaceURI)) {
            return;
        }
        IslandSchema is = this.dispatcher.getSchemaProvider().getSchemaByNamespace(namespaceURI);
        if (is == null) {
            return;
        }
        IslandVerifier iv = is.createNewVerifier(namespaceURI, is.getElementDecls());
        this.dispatcher.switchVerifier(iv);
        iv.startElement(namespaceURI, localName, qName, attributes);
    }
}

