/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.gui;

import java.lang.reflect.UndeclaredThrowableException;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.internal.GuiServiceActivator;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleContext;

public class LazyConfigurationForm
implements ConfigurationForm {
    private static ResourceManagementService resources;
    private final ClassLoader formClassLoader;
    private final String formClassName;
    private final String iconID;
    private final int index;
    private final String titleID;
    private final boolean isAdvanced;

    private static ResourceManagementService getResources() {
        if (resources == null) {
            resources = ResourceManagementServiceUtils.getService((BundleContext)GuiServiceActivator.getBundleContext());
        }
        return resources;
    }

    public LazyConfigurationForm(String formClassName, ClassLoader formClassLoader, String iconID, String titleID) {
        this(formClassName, formClassLoader, iconID, titleID, -1, false);
    }

    public LazyConfigurationForm(String formClassName, ClassLoader formClassLoader, String iconID, String titleID, int index) {
        this(formClassName, formClassLoader, iconID, titleID, index, false);
    }

    public LazyConfigurationForm(String formClassName, ClassLoader formClassLoader, String iconID, String titleID, int index, boolean isAdvanced) {
        this.formClassName = formClassName;
        this.formClassLoader = formClassLoader;
        this.iconID = iconID;
        this.titleID = titleID;
        this.index = index;
        this.isAdvanced = isAdvanced;
    }

    @Override
    public Object getForm() {
        ReflectiveOperationException exception;
        try {
            return Class.forName(this.getFormClassName(), true, this.getFormClassLoader()).newInstance();
        }
        catch (ClassNotFoundException ex) {
            exception = ex;
        }
        catch (IllegalAccessException ex) {
            exception = ex;
        }
        catch (InstantiationException ex) {
            exception = ex;
        }
        throw new UndeclaredThrowableException(exception);
    }

    protected ClassLoader getFormClassLoader() {
        return this.formClassLoader;
    }

    public String getFormClassName() {
        return this.formClassName;
    }

    @Override
    public byte[] getIcon() {
        return LazyConfigurationForm.getResources().getImageInBytes(this.getIconID());
    }

    protected String getIconID() {
        return this.iconID;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getTitle() {
        return LazyConfigurationForm.getResources().getI18NString(this.getTitleID());
    }

    protected String getTitleID() {
        return this.titleID;
    }

    @Override
    public boolean isAdvanced() {
        return this.isAdvanced;
    }
}

